'use strict';

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var _require = require('../result/result'),
    Error = _require.Error,
    Ok = _require.Ok;

var deprecated = require('../helpers/warn-deprecation');

/*~
 * stability: stable
 * authors:
 *   - "@boris-marinov"
 * 
 * type: |
 *   forall a, b:
 *     (a or None, b) => Result b a
 *   & (a or None) => Result None a
 */
var nullableToResult = function nullableToResult(a, givenFallback) {
  var oldBehaviour = arguments.length < 2; // eslint-disable-line prefer-rest-params
  if (oldBehaviour) {
    deprecated('nullableToResult(value) is being deprecated in favour of providing an explicit fallback value.\nnullableToResult(value, fallback) is the new preferred form of this function.\n');
  }

  var fallback = oldBehaviour ? a : givenFallback;
  return a != null ? Ok(a) : /* else */Error(fallback);
};

module.exports = nullableToResult;