'use strict';

var __metamagical_withMeta = function metamagical_withMeta(object, meta) {
  var parent = Object.getPrototypeOf(object);var oldMeta = object[Symbol.for('@@meta:magical')] || {};if (parent && parent[Symbol.for('@@meta:magical')] === oldMeta) {
    oldMeta = {};
  }Object.keys(meta).forEach(function (key) {
    if (/^~/.test(key)) {
      oldMeta[key.slice(1)] = meta[key];
    } else {
      oldMeta[key] = meta[key];
    }
  });object[Symbol.for('@@meta:magical')] = oldMeta;return object;
},
    _metamagical_withMet,
    _metamagical_withMet2;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var Result = require('./result');

var _require = require('../adt/union/union'),
    typeSymbol = _require.typeSymbol;

/*~
 * stability: stable
 * name: module folktale/result
 */


module.exports = __metamagical_withMeta((_metamagical_withMet = (_metamagical_withMet2 = {
  Error: Result.Error,
  Ok: Result.Ok,
  hasInstance: Result.hasInstance,
  of: Result.of,
  fromJSON: Result.fromJSON
}, _defineProperty(_metamagical_withMet2, typeSymbol, Result[typeSymbol]), _defineProperty(_metamagical_withMet2, 'try', require('./try')), _defineProperty(_metamagical_withMet2, 'fromNullable', function fromNullable(aNullable, fallbackValue) {
  var nullableToResult = require('../conversions/nullable-to-result');

  if (arguments.length > 1) {
    // eslint-disable-line prefer-rest-params 
    return nullableToResult(aNullable, fallbackValue);
  } else {
    return nullableToResult(aNullable);
  }
}), _defineProperty(_metamagical_withMet2, 'fromValidation', function fromValidation(aValidation) {
  return require('../conversions/validation-to-result')(aValidation);
}), _defineProperty(_metamagical_withMet2, 'fromMaybe', function fromMaybe(aMaybe, failureValue) {
  return require('../conversions/maybe-to-result')(aMaybe, failureValue);
}), _metamagical_withMet2), __metamagical_withMeta(_metamagical_withMet['fromNullable'], {
  'name': 'fromNullable',
  'source': 'fromNullable(aNullable, fallbackValue) {\r\n    const nullableToResult = require(\'folktale/conversions/nullable-to-result\');\r\n\r\n    if (arguments.length > 1) {  // eslint-disable-line prefer-rest-params \r\n      return nullableToResult(aNullable, fallbackValue);\r\n    } else {\r\n      return nullableToResult(aNullable);\r\n    }\r\n  }',
  'signature': 'fromNullable(aNullable, fallbackValue)',
  'location': {
    'filename': 'source/result/index.js',
    'start': {
      'line': 18,
      'column': 17
    },
    'end': {
      'line': 57,
      'column': 1
    }
  },
  'module': 'folktale/result',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'type': 'forall a, b: (a or None, b) => Result b a\n| (a or None) => Result None a\n \n'
}), __metamagical_withMeta(_metamagical_withMet['fromValidation'], {
  'name': 'fromValidation',
  'source': 'fromValidation(aValidation) {\r\n    return require(\'folktale/conversions/validation-to-result\')(aValidation);\r\n  }',
  'signature': 'fromValidation(aValidation)',
  'location': {
    'filename': 'source/result/index.js',
    'start': {
      'line': 18,
      'column': 17
    },
    'end': {
      'line': 57,
      'column': 1
    }
  },
  'module': 'folktale/result',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'type': 'forall a, b: (Validation a b) => Result a b\n \n'
}), __metamagical_withMeta(_metamagical_withMet['fromMaybe'], {
  'name': 'fromMaybe',
  'source': 'fromMaybe(aMaybe, failureValue) {\r\n    return require(\'folktale/conversions/maybe-to-result\')(aMaybe, failureValue);\r\n  }',
  'signature': 'fromMaybe(aMaybe, failureValue)',
  'location': {
    'filename': 'source/result/index.js',
    'start': {
      'line': 18,
      'column': 17
    },
    'end': {
      'line': 57,
      'column': 1
    }
  },
  'module': 'folktale/result',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'type': 'forall a, b: (Maybe b, a) => Result a b\n \n'
}), _metamagical_withMet), {
  'name': 'module folktale/result',
  'source': '{\r\n  Error: Result.Error,\r\n  Ok: Result.Ok,\r\n  hasInstance: Result.hasInstance,\r\n  of: Result.of,\r\n  fromJSON: Result.fromJSON,\r\n  [typeSymbol]: Result[typeSymbol],\r\n  try: require(\'./try\'),\r\n\r\n  /*~\r\n   * type: |\r\n   *   forall a, b: (a or None, b) => Result b a\r\n   *   | (a or None) => Result None a\r\n   */\r\n  fromNullable(aNullable, fallbackValue) {\r\n    const nullableToResult = require(\'folktale/conversions/nullable-to-result\');\r\n\r\n    if (arguments.length > 1) {  // eslint-disable-line prefer-rest-params \r\n      return nullableToResult(aNullable, fallbackValue);\r\n    } else {\r\n      return nullableToResult(aNullable);\r\n    }\r\n  },\r\n\r\n  /*~\r\n   * type: |\r\n   *   forall a, b: (Validation a b) => Result a b\r\n   */\r\n  fromValidation(aValidation) {\r\n    return require(\'folktale/conversions/validation-to-result\')(aValidation);\r\n  },\r\n\r\n  /*~\r\n   * type: |\r\n   *   forall a, b: (Maybe b, a) => Result a b\r\n   */\r\n  fromMaybe(aMaybe, failureValue) {\r\n    return require(\'folktale/conversions/maybe-to-result\')(aMaybe, failureValue);\r\n  }\r\n}',
  'location': {
    'filename': 'source/result/index.js',
    'start': {
      'line': 18,
      'column': 0
    },
    'end': {
      'line': 57,
      'column': 2
    }
  },
  'module': 'folktale/result',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'isModule': true,
  'stability': 'stable'
});