"use strict";

var __metamagical_withMeta = function metamagical_withMeta(object, meta) {
  var parent = Object.getPrototypeOf(object);var oldMeta = object[Symbol.for('@@meta:magical')] || {};if (parent && parent[Symbol.for('@@meta:magical')] === oldMeta) {
    oldMeta = {};
  }Object.keys(meta).forEach(function (key) {
    if (/^~/.test(key)) {
      oldMeta[key.slice(1)] = meta[key];
    } else {
      oldMeta[key] = meta[key];
    }
  });object[Symbol.for('@@meta:magical')] = oldMeta;return object;
};

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var hole = {};

/*~
 * stability: experimental
 * authors:
 *   - Quildreen Motta
 *
 * type: |
 *   (Number, (Any... => Any)) => ((hole | Any)...) => Any :: (throw TypeError)
 */
var partialize = __metamagical_withMeta(function (arity, fn) {
  return function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    //  eslint-disable-line max-statements
    /* eslint-disable no-magic-numbers */
    if (args.length < arity) {
      throw new TypeError("The partial function takes at least " + arity + " arguments, but was given " + args.length + ".");
    }

    // Figure out if we have holes
    var holes = 0;
    for (var i = 0; i < args.length; ++i) {
      if (args[i] === hole) {
        holes += 1;
      }
    }

    if (holes > 0) {
      return partialize(holes, function () {
        // eslint-disable-line max-statements
        var realArgs = []; // eslint-disable-line prefer-const
        var argIndex = 0;

        for (var _i = 0; _i < args.length; ++_i) {
          var arg = args[_i];
          if (arg === hole) {
            realArgs.push(arguments.length <= argIndex ? undefined : arguments[argIndex]);
            argIndex += 1;
          } else {
            realArgs.push(arg);
          }
        }

        return fn.apply(undefined, realArgs);
      });
    } else {
      return fn.apply(undefined, args);
    }
  };
}, {
  "name": "partialize",
  "source": "(arity, fn) => (...args) => {    //  eslint-disable-line max-statements\r\n  /* eslint-disable no-magic-numbers */\r\n  if (args.length < arity) {\r\n    throw new TypeError(`The partial function takes at least ${arity} arguments, but was given ${args.length}.`);\r\n  }\r\n\r\n  // Figure out if we have holes\r\n  let holes = 0;\r\n  for (let i = 0; i < args.length; ++i) {\r\n    if (args[i] === hole) {\r\n      holes += 1;\r\n    }\r\n  }\r\n\r\n\r\n  if (holes > 0) {\r\n    return partialize(holes, (...newArgs) => {    // eslint-disable-line max-statements\r\n      let realArgs = [];    // eslint-disable-line prefer-const\r\n      let argIndex = 0;\r\n\r\n      for (let i = 0; i < args.length; ++i) {\r\n        const arg = args[i];\r\n        if (arg === hole) {\r\n          realArgs.push(newArgs[argIndex]);\r\n          argIndex += 1;\r\n        } else {\r\n          realArgs.push(arg);\r\n        }\r\n      }\r\n\r\n      return fn(...realArgs);\r\n    });\r\n  } else {\r\n    return fn(...args);\r\n  }\r\n}",
  "signature": "partialize(arity, fn)",
  "location": {
    "filename": "source/core/lambda/partialize.js",
    "start": {
      "line": 21,
      "column": 0
    },
    "end": {
      "line": 56,
      "column": 2
    }
  },
  "module": "folktale/core/lambda/partialize",
  "licence": "MIT",
  "authors": ["Quildreen Motta"],
  "repository": "https://github.com/origamitower/folktale",
  "npmPackage": "folktale",
  "copyright": "(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS",
  "maintainers": ["Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)"],
  "stability": "experimental",
  "type": "(Number, (Any... => Any)) => ((hole | Any)...) => Any :: (throw TypeError)\n"
}); /* eslint-enable no-magic-numbers */

// ---[ Special Values ]-----------------------------------------------
/*~ stability: experimental */
partialize.hole = __metamagical_withMeta(hole, {
  "name": "hole",
  "source": "hole",
  "belongsTo": function belongsTo() {
    return partialize;
  },
  "stability": "experimental"
});

// --[ Exports ]-------------------------------------------------------
module.exports = partialize;