'use strict';

var __metamagical_withMeta = function metamagical_withMeta(object, meta) {
  var parent = Object.getPrototypeOf(object);var oldMeta = object[Symbol.for('@@meta:magical')] || {};if (parent && parent[Symbol.for('@@meta:magical')] === oldMeta) {
    oldMeta = {};
  }Object.keys(meta).forEach(function (key) {
    if (/^~/.test(key)) {
      oldMeta[key.slice(1)] = meta[key];
    } else {
      oldMeta[key] = meta[key];
    }
  });object[Symbol.for('@@meta:magical')] = oldMeta;return object;
};

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var _require = require('../result/result'),
    Error = _require.Error,
    Ok = _require.Ok;

var deprecated = require('../helpers/warn-deprecation');

/*~
 * stability: stable
 * authors:
 *   - "@boris-marinov"
 * 
 * type: |
 *   forall a, b:
 *     (a or None, b) => Result b a
 *   & (a or None) => Result None a
 */
var nullableToResult = __metamagical_withMeta(function (a, givenFallback) {
  var oldBehaviour = arguments.length < 2; // eslint-disable-line prefer-rest-params
  if (oldBehaviour) {
    deprecated('nullableToResult(value) is being deprecated in favour of providing an explicit fallback value.\nnullableToResult(value, fallback) is the new preferred form of this function.\n');
  }

  var fallback = oldBehaviour ? a : givenFallback;
  return a != null ? Ok(a) : /* else */Error(fallback);
}, {
  'name': 'nullableToResult',
  'source': 'function(a, givenFallback) {\r\n  const oldBehaviour = arguments.length < 2;  // eslint-disable-line prefer-rest-params\r\n  if (oldBehaviour) {\r\n    deprecated(`nullableToResult(value) is being deprecated in favour of providing an explicit fallback value.\r\nnullableToResult(value, fallback) is the new preferred form of this function.\r\n`);\r\n  }\r\n\r\n  const fallback = oldBehaviour ? a : givenFallback;\r\n  return a != null ?  Ok(a)\r\n  :      /* else */   Error(fallback);\r\n}',
  'signature': 'nullableToResult(a, givenFallback)',
  'location': {
    'filename': 'source/conversions/nullable-to-result.js',
    'start': {
      'line': 24,
      'column': 0
    },
    'end': {
      'line': 35,
      'column': 2
    }
  },
  'module': 'folktale/conversions/nullable-to-result',
  'licence': 'MIT',
  'authors': ['@boris-marinov'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'stable',
  'type': 'forall a, b:\n  (a or None, b) => Result b a\n& (a or None) => Result None a\n'
});

module.exports = nullableToResult;