'use strict';

var __metamagical_withMeta = function metamagical_withMeta(object, meta) {
  var parent = Object.getPrototypeOf(object);var oldMeta = object[Symbol.for('@@meta:magical')] || {};if (parent && parent[Symbol.for('@@meta:magical')] === oldMeta) {
    oldMeta = {};
  }Object.keys(meta).forEach(function (key) {
    if (/^~/.test(key)) {
      oldMeta[key.slice(1)] = meta[key];
    } else {
      oldMeta[key] = meta[key];
    }
  });object[Symbol.for('@@meta:magical')] = oldMeta;return object;
},
    _metamagical_withMet;

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var Task = require('./_task');

/*~ 
 * stability: experimental 
 * name: module folktale/concurrency/task
 */
module.exports = __metamagical_withMeta((_metamagical_withMet = {
  of: Task.of,
  rejected: Task.rejected,
  task: require('./task'),
  waitAny: require('./wait-any'),
  waitAll: require('./wait-all'),
  do: require('./do'),
  _Task: Task,
  _TaskExecution: require('./_task-execution'),
  fromNodeback: function fromNodeback(aNodeback) {
    return require('../../conversions/nodeback-to-task')(aNodeback);
  },
  fromPromised: function fromPromised(aPromiseFn) {
    return require('../../conversions/promised-to-task')(aPromiseFn);
  }
}, __metamagical_withMeta(_metamagical_withMet['fromNodeback'], {
  'name': 'fromNodeback',
  'source': 'fromNodeback(aNodeback) {\r\n    return require(\'folktale/conversions/nodeback-to-task\')(aNodeback);\r\n  }',
  'signature': 'fromNodeback(aNodeback)',
  'location': {
    'filename': 'source/concurrency/task/index.js',
    'start': {
      'line': 17,
      'column': 17
    },
    'end': {
      'line': 48,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall s, e:\n  ((Any..., (e, s) => Void) => Void)\n  => (Any...)\n  => Task e s\n'
}), __metamagical_withMeta(_metamagical_withMet['fromPromised'], {
  'name': 'fromPromised',
  'source': 'fromPromised(aPromiseFn) {\r\n    return require(\'folktale/conversions/promised-to-task\')(aPromiseFn);\r\n  }',
  'signature': 'fromPromised(aPromiseFn)',
  'location': {
    'filename': 'source/concurrency/task/index.js',
    'start': {
      'line': 17,
      'column': 17
    },
    'end': {
      'line': 48,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v:\n  ((Any...) => Promise v e) => (Any...) => Task e v\n \n'
}), _metamagical_withMet), {
  'name': 'module folktale/concurrency/task',
  'source': '{\r\n  of: Task.of,\r\n  rejected: Task.rejected,\r\n  task: require(\'./task\'),\r\n  waitAny: require(\'./wait-any\'),\r\n  waitAll: require(\'./wait-all\'),\r\n  do: require(\'./do\'),\r\n  _Task: Task,\r\n  _TaskExecution: require(\'./_task-execution\'),\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *    forall s, e:\r\n   *      ((Any..., (e, s) => Void) => Void)\r\n   *      => (Any...)\r\n   *      => Task e s\r\n   */\r\n  fromNodeback(aNodeback) {\r\n    return require(\'folktale/conversions/nodeback-to-task\')(aNodeback);\r\n  },\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v:\r\n   *     ((Any...) => Promise v e) => (Any...) => Task e v\r\n   */\r\n  fromPromised(aPromiseFn) {\r\n    return require(\'folktale/conversions/promised-to-task\')(aPromiseFn);\r\n  }\r\n}',
  'location': {
    'filename': 'source/concurrency/task/index.js',
    'start': {
      'line': 17,
      'column': 0
    },
    'end': {
      'line': 48,
      'column': 2
    }
  },
  'module': 'folktale/concurrency/task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'isModule': true,
  'stability': 'experimental'
});