'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var __metamagical_withMeta = function metamagical_withMeta(object, meta) {
  var parent = Object.getPrototypeOf(object);var oldMeta = object[Symbol.for('@@meta:magical')] || {};if (parent && parent[Symbol.for('@@meta:magical')] === oldMeta) {
    oldMeta = {};
  }Object.keys(meta).forEach(function (key) {
    if (/^~/.test(key)) {
      oldMeta[key.slice(1)] = meta[key];
    } else {
      oldMeta[key] = meta[key];
    }
  });object[Symbol.for('@@meta:magical')] = oldMeta;return object;
},
    _Object$assign;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var provideAliases = require('../../helpers/provide-fantasy-land-aliases');
var defer = require('../../helpers/defer');
var Deferred = require('../future/_deferred');
var TaskExecution = require('./_task-execution');

var noop = function noop() {};

/*~ stability: experimental */

var Task = __metamagical_withMeta(function () {
  var _ref, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9, _ref10, _ref11;

  /*~
   * stability: experimental
   * type: |
   *   forall value, reason:
   *     new (
   *       ({
   *          resolve: (value) => Void,
   *          reject: (reason) => Void,
   *          cancel: () => Void,
   *          cleanup: (() => Void) => Void,
   *          onCancelled: (() => Void) => Void,
   *          get isCancelled: Boolean
   *        }) => Void
   *     ) => Task value reason
   */
  function Task(computation) {
    _classCallCheck(this, Task);

    this._computation = computation;
  }

  /*~
   * stability: experimental
   * type: |
   *   forall e, v1, v2:
   *     (Task e v1).((v1) => Task e v2) => Task e v2
   */


  __metamagical_withMeta(Task, {
    'name': 'Task',
    'source': 'constructor(computation) {\r\n    this._computation = computation;\r\n  }',
    'signature': 'Task(computation)',
    'location': {
      'filename': 'source/concurrency/task/_task.js',
      'start': {
        'line': 36,
        'column': 2
      },
      'end': {
        'line': 38,
        'column': 3
      }
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall value, reason:\n  new (\n    ({\n       resolve: (value) => Void,\n       reject: (reason) => Void,\n       cancel: () => Void,\n       cleanup: (() => Void) => Void,\n       onCancelled: (() => Void) => Void,\n       get isCancelled: Boolean\n     }) => Void\n  ) => Task value reason\n \n'
  });

  _createClass(Task, [(_ref = {
    key: 'chain',
    value: function chain(transformation) {
      var _this = this;

      return new Task(function (resolver) {
        var execution = _this.run();
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        execution.listen({
          onCancelled: resolver.cancel,
          onRejected: resolver.reject,
          onResolved: function onResolved(value) {
            transformation(value).run().listen({
              onCancelled: resolver.cancel,
              onRejected: resolver.reject,
              onResolved: resolver.resolve
            });
          }
        });
      });
    }
  }, __metamagical_withMeta(_ref['value'], {
    'name': 'value',
    'signature': 'value(transformation)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v1, v2:\n  (Task e v1).((v1) => Task e v2) => Task e v2\n \n'
  }), _ref), (_ref2 = {
    key: 'map',
    value: function map(transformation) {
      var _this2 = this;

      return new Task(function (resolver) {
        var execution = _this2.run();
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        execution.listen({
          onCancelled: resolver.cancel,
          onRejected: resolver.reject,
          onResolved: function onResolved(value) {
            return resolver.resolve(transformation(value));
          }
        });
      });
    }
  }, __metamagical_withMeta(_ref2['value'], {
    'name': 'value',
    'signature': 'value(transformation)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v1, v2:\n  (Task e v1).((v1) => v2) => Task e v2\n \n'
  }), _ref2), (_ref3 = {
    key: 'mapRejected',
    value: function mapRejected(transformation) {
      var _this3 = this;

      return new Task(function (resolver) {
        var execution = _this3.run();
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        execution.listen({
          onCancelled: resolver.cancel,
          onRejected: function onRejected(reason) {
            return resolver.reject(transformation(reason));
          },
          onResolved: resolver.resolve
        });
      });
    }
  }, __metamagical_withMeta(_ref3['value'], {
    'name': 'value',
    'signature': 'value(transformation)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e1, e2, v:\n  (Task e1 v).((e1) => e2) => Task e2 v\n \n'
  }), _ref3), (_ref4 = {
    key: 'apply',
    value: function apply(task) {
      return this.chain(function (f) {
        return task.map(f);
      });
    }
  }, __metamagical_withMeta(_ref4['value'], {
    'name': 'value',
    'signature': 'value(task)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v1, v2:\n  (Task e ((v1) => v2)).(Task e v1) => Task e v2\n \n'
  }), _ref4), (_ref5 = {
    key: 'bimap',
    value: function bimap(rejectionTransformation, successTransformation) {
      var _this4 = this;

      return new Task(function (resolver) {
        var execution = _this4.run();
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        execution.listen({
          onCancelled: resolver.cancel,
          onRejected: function onRejected(reason) {
            return resolver.reject(rejectionTransformation(reason));
          },
          onResolved: function onResolved(value) {
            return resolver.resolve(successTransformation(value));
          }
        });
      });
    }
  }, __metamagical_withMeta(_ref5['value'], {
    'name': 'value',
    'signature': 'value(rejectionTransformation, successTransformation)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e1, e2, v1, v2:\n  (Task e1 v1).((e1) => e2, (v1) => v2) => Task e2 v2\n \n'
  }), _ref5), (_ref6 = {
    key: 'willMatchWith',
    value: function willMatchWith(pattern) {
      var _this5 = this;

      return new Task(function (resolver) {
        var execution = _this5.run();
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        var resolve = function resolve(handler) {
          return function (value) {
            return handler(value).run().listen({
              onCancelled: resolver.cancel,
              onRejected: resolver.reject,
              onResolved: resolver.resolve
            });
          };
        };
        execution.listen({
          onCancelled: resolve(function (_) {
            return pattern.Cancelled();
          }),
          onRejected: resolve(pattern.Rejected),
          onResolved: resolve(pattern.Resolved)
        });
      });
    }
  }, __metamagical_withMeta(_ref6['value'], {
    'name': 'value',
    'signature': 'value(pattern)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e1, e2, v1, v2:\n  type Pattern = { row |\n    Cancelled: ()  => Task e2 v2,\n    Resolved:  (b) => Task e2 v2,\n    Rejected:  (a) => Task e2 v2\n  }\n\n  (Task e1 v1).(Pattern) => Task e2 v2\n \n'
  }), _ref6), (_ref7 = {
    key: 'swap',
    value: function swap() {
      var _this6 = this;

      return new Task(function (resolver) {
        var execution = _this6.run(); // eslint-disable-line prefer-const
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        execution.listen({
          onCancelled: resolver.cancel,
          onRejected: resolver.resolve,
          onResolved: resolver.reject
        });
      });
    }
  }, __metamagical_withMeta(_ref7['value'], {
    'name': 'value',
    'signature': 'value()',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v: (Task e v).() => Task v e\n \n'
  }), _ref7), (_ref8 = {
    key: 'orElse',
    value: function orElse(handler) {
      var _this7 = this;

      return new Task(function (resolver) {
        var execution = _this7.run();
        resolver.onCancelled(function () {
          return execution.cancel();
        });

        execution.listen({
          onCancelled: resolver.cancel,
          onResolved: resolver.resolve,
          onRejected: function onRejected(reason) {
            handler(reason).run().listen({
              onCancelled: resolver.cancel,
              onRejected: resolver.reject,
              onResolved: resolver.resolve
            });
          }
        });
      });
    }
  }, __metamagical_withMeta(_ref8['value'], {
    'name': 'value',
    'signature': 'value(handler)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, e2, v:\n  (Task e v).((e) => Task e2 v) => Task e2 v\n \n'
  }), _ref8), (_ref9 = {
    key: 'or',
    value: function or(that) {
      var _this8 = this;

      return new Task(function (resolver) {
        var thisExecution = _this8.run(); // eslint-disable-line prefer-const
        var thatExecution = that.run(); // eslint-disable-line prefer-const
        var done = false;

        resolver.onCancelled(function () {
          thisExecution.cancel();
          thatExecution.cancel();
        });

        var guard = function guard(fn, execution) {
          return function (value) {
            if (!done) {
              done = true;
              execution.cancel();
              fn(value);
            }
          };
        };

        thisExecution.listen({
          onRejected: guard(resolver.reject, thatExecution),
          onCancelled: guard(resolver.cancel, thatExecution),
          onResolved: guard(resolver.resolve, thatExecution)
        });

        thatExecution.listen({
          onRejected: guard(resolver.reject, thisExecution),
          onCancelled: guard(resolver.cancel, thisExecution),
          onResolved: guard(resolver.resolve, thisExecution)
        });
      });
    }
  }, __metamagical_withMeta(_ref9['value'], {
    'name': 'value',
    'signature': 'value(that)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v:\n  (Task e v).(Task e v) => Task e v\n \n'
  }), _ref9), (_ref10 = {
    key: 'and',
    value: function and(that) {
      var _this9 = this;

      return new Task(function (resolver) {
        // eslint-disable-line max-statements
        var thisExecution = _this9.run(); // eslint-disable-line prefer-const
        var thatExecution = that.run(); // eslint-disable-line prefer-const
        var valueLeft = null;
        var valueRight = null;
        var doneLeft = false;
        var doneRight = false;
        var cancelled = false;

        resolver.onCancelled(function () {
          thisExecution.cancel();
          thatExecution.cancel();
        });

        var guardResolve = function guardResolve(setter) {
          return function (value) {
            if (cancelled) return;

            setter(value);
            if (doneLeft && doneRight) {
              resolver.resolve([valueLeft, valueRight]);
            }
          };
        };

        var guardRejection = function guardRejection(fn, execution) {
          return function (value) {
            if (cancelled) return;

            cancelled = true;
            execution.cancel();
            fn(value);
          };
        };

        thisExecution.listen({
          onRejected: guardRejection(resolver.reject, thatExecution),
          onCancelled: guardRejection(resolver.cancel, thatExecution),
          onResolved: guardResolve(function (x) {
            valueLeft = x;
            doneLeft = true;
          })
        });

        thatExecution.listen({
          onRejected: guardRejection(resolver.reject, thisExecution),
          onCancelled: guardRejection(resolver.cancel, thisExecution),
          onResolved: guardResolve(function (x) {
            valueRight = x;
            doneRight = true;
          })
        });
      });
    }
  }, __metamagical_withMeta(_ref10['value'], {
    'name': 'value',
    'signature': 'value(that)',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v1, v2:\n  (Task e v1).(Task e v2) => Task e (v1, v2)\n \n'
  }), _ref10), (_ref11 = {
    key: 'run',
    value: function run() {
      var deferred = new Deferred(); // eslint-disable-line prefer-const
      var cleanups = [];
      var cancellations = [];
      var isCancelled = false;
      var done = false;

      deferred.listen({
        onCancelled: function onCancelled(_) {
          done = true;
          isCancelled = true;
          cancellations.forEach(function (f) {
            return f();
          });
          cleanups.forEach(function (f) {
            return f();
          });
          cancellations = [];
          cleanups = [];
        },

        onResolved: function onResolved(_value) {
          done = true;
          cleanups.forEach(function (f) {
            return f();
          });
          cleanups = [];
          cancellations = [];
        },

        onRejected: function onRejected(_reason) {
          done = true;
          cleanups.forEach(function (f) {
            return f();
          });
          cleanups = [];
          cancellations = [];
        }
      });

      var resources = this._computation({
        reject: function reject(error) {
          deferred.reject(error);
        },
        resolve: function resolve(value) {
          deferred.resolve(value);
        },
        cancel: function cancel(_) {
          deferred.maybeCancel();
        },

        get isCancelled() {
          return isCancelled;
        },
        cleanup: function cleanup(f) {
          if (done) {
            throw new Error('Can\'t attach a cleanup handler after the task is settled.');
          }
          cleanups.push(f);
        },
        onCancelled: function onCancelled(f) {
          if (done) {
            throw new Error('Can\'t attach a cancellation handler after the task is settled.');
          }
          cancellations.push(f);
        }
      });

      return new TaskExecution(this, deferred);
    }
  }, __metamagical_withMeta(_ref11['value'], {
    'name': 'value',
    'signature': 'value()',
    'location': {
      'filename': 'source/concurrency/task/_task.js'
    },
    'module': 'folktale/concurrency/task/_task',
    'licence': 'MIT',
    'authors': ['Quildreen Motta'],
    'repository': 'https://github.com/origamitower/folktale',
    'npmPackage': 'folktale',
    'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
    'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
    'stability': 'experimental',
    'type': 'forall e, v: (Task e v).() => TaskExecution e v\n \n'
  }), _ref11)]);

  return Task;
}(), {
  'name': 'Task',
  'source': 'class Task {\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall value, reason:\r\n   *     new (\r\n   *       ({\r\n   *          resolve: (value) => Void,\r\n   *          reject: (reason) => Void,\r\n   *          cancel: () => Void,\r\n   *          cleanup: (() => Void) => Void,\r\n   *          onCancelled: (() => Void) => Void,\r\n   *          get isCancelled: Boolean\r\n   *        }) => Void\r\n   *     ) => Task value reason\r\n   */\r\n  constructor(computation) {\r\n    this._computation = computation;\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e v1).((v1) => Task e v2) => Task e v2\r\n   */\r\n  chain(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  value => {\r\n          transformation(value).run().listen({\r\n            onCancelled: resolver.cancel,\r\n            onRejected:  resolver.reject,\r\n            onResolved:  resolver.resolve\r\n          });\r\n        }\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e v1).((v1) => v2) => Task e v2\r\n   */\r\n  map(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  value => resolver.resolve(transformation(value))\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e1, e2, v:\r\n   *     (Task e1 v).((e1) => e2) => Task e2 v\r\n   */\r\n  mapRejected(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  reason => resolver.reject(transformation(reason)),\r\n        onResolved:  resolver.resolve\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e ((v1) => v2)).(Task e v1) => Task e v2\r\n   */\r\n  apply(task) {\r\n    return this.chain(f => task.map(f));\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e1, e2, v1, v2:\r\n   *     (Task e1 v1).((e1) => e2, (v1) => v2) => Task e2 v2\r\n   */\r\n  bimap(rejectionTransformation, successTransformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  reason => resolver.reject(rejectionTransformation(reason)),\r\n        onResolved:  value => resolver.resolve(successTransformation(value))\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e1, e2, v1, v2:\r\n   *     type Pattern = { row |\r\n   *       Cancelled: ()  => Task e2 v2,\r\n   *       Resolved:  (b) => Task e2 v2,\r\n   *       Rejected:  (a) => Task e2 v2\r\n   *     }\r\n   *\r\n   *     (Task e1 v1).(Pattern) => Task e2 v2\r\n   */\r\n  willMatchWith(pattern) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n      \r\n      const resolve = (handler) => (value) => handler(value).run().listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  resolver.resolve\r\n      });\r\n      execution.listen({\r\n        onCancelled: resolve(_ => pattern.Cancelled()),\r\n        onRejected:  resolve(pattern.Rejected),\r\n        onResolved:  resolve(pattern.Resolved)\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v: (Task e v).() => Task v e\r\n   */\r\n  swap() {\r\n    return new Task(resolver => {\r\n      let execution = this.run();   // eslint-disable-line prefer-const\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.resolve,\r\n        onResolved:  resolver.reject\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, e2, v:\r\n   *     (Task e v).((e) => Task e2 v) => Task e2 v\r\n   */\r\n  orElse(handler) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onResolved:  resolver.resolve,\r\n        onRejected:  reason => {\r\n          handler(reason).run().listen({\r\n            onCancelled: resolver.cancel,\r\n            onRejected:  resolver.reject,\r\n            onResolved:  resolver.resolve\r\n          });\r\n        }\r\n      });\r\n    });\r\n  }\r\n\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v:\r\n   *     (Task e v).(Task e v) => Task e v\r\n   */\r\n  or(that) {\r\n    return new Task(resolver => {\r\n      let thisExecution = this.run();   // eslint-disable-line prefer-const\r\n      let thatExecution = that.run();   // eslint-disable-line prefer-const\r\n      let done = false;\r\n\r\n      resolver.onCancelled(() => {\r\n        thisExecution.cancel();\r\n        thatExecution.cancel();\r\n      });\r\n\r\n      const guard = (fn, execution) => (value) => {\r\n        if (!done) {\r\n          done = true;\r\n          execution.cancel();\r\n          fn(value);\r\n        }\r\n      };\r\n\r\n      thisExecution.listen({\r\n        onRejected:  guard(resolver.reject, thatExecution),\r\n        onCancelled: guard(resolver.cancel, thatExecution),\r\n        onResolved:  guard(resolver.resolve, thatExecution)\r\n      });\r\n\r\n      thatExecution.listen({\r\n        onRejected:  guard(resolver.reject, thisExecution),\r\n        onCancelled: guard(resolver.cancel, thisExecution),\r\n        onResolved:  guard(resolver.resolve, thisExecution)\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e v1).(Task e v2) => Task e (v1, v2)\r\n   */\r\n  and(that) {\r\n    return new Task(resolver => {   // eslint-disable-line max-statements\r\n      let thisExecution = this.run();   // eslint-disable-line prefer-const\r\n      let thatExecution = that.run();   // eslint-disable-line prefer-const\r\n      let valueLeft = null;\r\n      let valueRight = null;\r\n      let doneLeft = false;\r\n      let doneRight = false;\r\n      let cancelled = false;\r\n\r\n      resolver.onCancelled(() => {\r\n        thisExecution.cancel();\r\n        thatExecution.cancel();\r\n      });\r\n\r\n      const guardResolve = (setter) => (value) => {\r\n        if (cancelled)  return;\r\n\r\n        setter(value);\r\n        if (doneLeft && doneRight) {\r\n          resolver.resolve([valueLeft, valueRight]);\r\n        }\r\n      };\r\n\r\n      const guardRejection = (fn, execution) => (value) => {\r\n        if (cancelled)  return;\r\n\r\n        cancelled = true;\r\n        execution.cancel();\r\n        fn(value);\r\n      };\r\n\r\n      thisExecution.listen({\r\n        onRejected:  guardRejection(resolver.reject, thatExecution),\r\n        onCancelled: guardRejection(resolver.cancel, thatExecution),\r\n        onResolved:  guardResolve(x => {\r\n          valueLeft = x;\r\n          doneLeft = true;\r\n        })\r\n      });\r\n\r\n      thatExecution.listen({\r\n        onRejected:  guardRejection(resolver.reject, thisExecution),\r\n        onCancelled: guardRejection(resolver.cancel, thisExecution),\r\n        onResolved:  guardResolve(x => {\r\n          valueRight = x;\r\n          doneRight = true;\r\n        })\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v: (Task e v).() => TaskExecution e v\r\n   */\r\n  run() {\r\n    let deferred = new Deferred();    // eslint-disable-line prefer-const\r\n    let cleanups      = [];\r\n    let cancellations = [];\r\n    let isCancelled   = false;\r\n    let done          = false;\r\n\r\n    deferred.listen({\r\n      onCancelled: _ => {\r\n        done = true;\r\n        isCancelled = true;\r\n        cancellations.forEach(f => f());\r\n        cleanups.forEach(f => f());\r\n        cancellations = [];\r\n        cleanups = [];\r\n      },\r\n\r\n      onResolved: _value => {\r\n        done = true;\r\n        cleanups.forEach(f => f());\r\n        cleanups = [];\r\n        cancellations = [];\r\n      },\r\n\r\n      onRejected: _reason => {\r\n        done = true;\r\n        cleanups.forEach(f => f());\r\n        cleanups = [];\r\n        cancellations = [];\r\n      }\r\n    });\r\n\r\n    const resources = this._computation({\r\n      reject:  error => { deferred.reject(error) },\r\n      resolve: value => { deferred.resolve(value) },\r\n      cancel:  _     => { deferred.maybeCancel() },\r\n\r\n      get isCancelled() { return isCancelled },\r\n      cleanup(f) {\r\n        if (done) {\r\n          throw new Error(\'Can\\\'t attach a cleanup handler after the task is settled.\');\r\n        }\r\n        cleanups.push(f);\r\n      },\r\n      onCancelled(f) {\r\n        if (done) {\r\n          throw new Error(\'Can\\\'t attach a cancellation handler after the task is settled.\');\r\n        }\r\n        cancellations.push(f);\r\n      }\r\n    });\r\n\r\n    return new TaskExecution(this, deferred);\r\n  }\r\n}',
  'location': {
    'filename': 'source/concurrency/task/_task.js'
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental'
});

__metamagical_withMeta(Task.prototype['run'], {
  'name': 'run',
  'source': 'run() {\r\n    let deferred = new Deferred();    // eslint-disable-line prefer-const\r\n    let cleanups      = [];\r\n    let cancellations = [];\r\n    let isCancelled   = false;\r\n    let done          = false;\r\n\r\n    deferred.listen({\r\n      onCancelled: _ => {\r\n        done = true;\r\n        isCancelled = true;\r\n        cancellations.forEach(f => f());\r\n        cleanups.forEach(f => f());\r\n        cancellations = [];\r\n        cleanups = [];\r\n      },\r\n\r\n      onResolved: _value => {\r\n        done = true;\r\n        cleanups.forEach(f => f());\r\n        cleanups = [];\r\n        cancellations = [];\r\n      },\r\n\r\n      onRejected: _reason => {\r\n        done = true;\r\n        cleanups.forEach(f => f());\r\n        cleanups = [];\r\n        cancellations = [];\r\n      }\r\n    });\r\n\r\n    const resources = this._computation({\r\n      reject:  error => { deferred.reject(error) },\r\n      resolve: value => { deferred.resolve(value) },\r\n      cancel:  _     => { deferred.maybeCancel() },\r\n\r\n      get isCancelled() { return isCancelled },\r\n      cleanup(f) {\r\n        if (done) {\r\n          throw new Error(\'Can\\\'t attach a cleanup handler after the task is settled.\');\r\n        }\r\n        cleanups.push(f);\r\n      },\r\n      onCancelled(f) {\r\n        if (done) {\r\n          throw new Error(\'Can\\\'t attach a cancellation handler after the task is settled.\');\r\n        }\r\n        cancellations.push(f);\r\n      }\r\n    });\r\n\r\n    return new TaskExecution(this, deferred);\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v: (Task e v).() => TaskExecution e v\n \n'
});

__metamagical_withMeta(Task.prototype['and'], {
  'name': 'and',
  'source': 'and(that) {\r\n    return new Task(resolver => {   // eslint-disable-line max-statements\r\n      let thisExecution = this.run();   // eslint-disable-line prefer-const\r\n      let thatExecution = that.run();   // eslint-disable-line prefer-const\r\n      let valueLeft = null;\r\n      let valueRight = null;\r\n      let doneLeft = false;\r\n      let doneRight = false;\r\n      let cancelled = false;\r\n\r\n      resolver.onCancelled(() => {\r\n        thisExecution.cancel();\r\n        thatExecution.cancel();\r\n      });\r\n\r\n      const guardResolve = (setter) => (value) => {\r\n        if (cancelled)  return;\r\n\r\n        setter(value);\r\n        if (doneLeft && doneRight) {\r\n          resolver.resolve([valueLeft, valueRight]);\r\n        }\r\n      };\r\n\r\n      const guardRejection = (fn, execution) => (value) => {\r\n        if (cancelled)  return;\r\n\r\n        cancelled = true;\r\n        execution.cancel();\r\n        fn(value);\r\n      };\r\n\r\n      thisExecution.listen({\r\n        onRejected:  guardRejection(resolver.reject, thatExecution),\r\n        onCancelled: guardRejection(resolver.cancel, thatExecution),\r\n        onResolved:  guardResolve(x => {\r\n          valueLeft = x;\r\n          doneLeft = true;\r\n        })\r\n      });\r\n\r\n      thatExecution.listen({\r\n        onRejected:  guardRejection(resolver.reject, thisExecution),\r\n        onCancelled: guardRejection(resolver.cancel, thisExecution),\r\n        onResolved:  guardResolve(x => {\r\n          valueRight = x;\r\n          doneRight = true;\r\n        })\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v1, v2:\n  (Task e v1).(Task e v2) => Task e (v1, v2)\n \n'
});

__metamagical_withMeta(Task.prototype['or'], {
  'name': 'or',
  'source': 'or(that) {\r\n    return new Task(resolver => {\r\n      let thisExecution = this.run();   // eslint-disable-line prefer-const\r\n      let thatExecution = that.run();   // eslint-disable-line prefer-const\r\n      let done = false;\r\n\r\n      resolver.onCancelled(() => {\r\n        thisExecution.cancel();\r\n        thatExecution.cancel();\r\n      });\r\n\r\n      const guard = (fn, execution) => (value) => {\r\n        if (!done) {\r\n          done = true;\r\n          execution.cancel();\r\n          fn(value);\r\n        }\r\n      };\r\n\r\n      thisExecution.listen({\r\n        onRejected:  guard(resolver.reject, thatExecution),\r\n        onCancelled: guard(resolver.cancel, thatExecution),\r\n        onResolved:  guard(resolver.resolve, thatExecution)\r\n      });\r\n\r\n      thatExecution.listen({\r\n        onRejected:  guard(resolver.reject, thisExecution),\r\n        onCancelled: guard(resolver.cancel, thisExecution),\r\n        onResolved:  guard(resolver.resolve, thisExecution)\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v:\n  (Task e v).(Task e v) => Task e v\n \n'
});

__metamagical_withMeta(Task.prototype['orElse'], {
  'name': 'orElse',
  'source': 'orElse(handler) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onResolved:  resolver.resolve,\r\n        onRejected:  reason => {\r\n          handler(reason).run().listen({\r\n            onCancelled: resolver.cancel,\r\n            onRejected:  resolver.reject,\r\n            onResolved:  resolver.resolve\r\n          });\r\n        }\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, e2, v:\n  (Task e v).((e) => Task e2 v) => Task e2 v\n \n'
});

__metamagical_withMeta(Task.prototype['swap'], {
  'name': 'swap',
  'source': 'swap() {\r\n    return new Task(resolver => {\r\n      let execution = this.run();   // eslint-disable-line prefer-const\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.resolve,\r\n        onResolved:  resolver.reject\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v: (Task e v).() => Task v e\n \n'
});

__metamagical_withMeta(Task.prototype['willMatchWith'], {
  'name': 'willMatchWith',
  'source': 'willMatchWith(pattern) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n      \r\n      const resolve = (handler) => (value) => handler(value).run().listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  resolver.resolve\r\n      });\r\n      execution.listen({\r\n        onCancelled: resolve(_ => pattern.Cancelled()),\r\n        onRejected:  resolve(pattern.Rejected),\r\n        onResolved:  resolve(pattern.Resolved)\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e1, e2, v1, v2:\n  type Pattern = { row |\n    Cancelled: ()  => Task e2 v2,\n    Resolved:  (b) => Task e2 v2,\n    Rejected:  (a) => Task e2 v2\n  }\n\n  (Task e1 v1).(Pattern) => Task e2 v2\n \n'
});

__metamagical_withMeta(Task.prototype['bimap'], {
  'name': 'bimap',
  'source': 'bimap(rejectionTransformation, successTransformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  reason => resolver.reject(rejectionTransformation(reason)),\r\n        onResolved:  value => resolver.resolve(successTransformation(value))\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e1, e2, v1, v2:\n  (Task e1 v1).((e1) => e2, (v1) => v2) => Task e2 v2\n \n'
});

__metamagical_withMeta(Task.prototype['apply'], {
  'name': 'apply',
  'source': 'apply(task) {\r\n    return this.chain(f => task.map(f));\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v1, v2:\n  (Task e ((v1) => v2)).(Task e v1) => Task e v2\n \n'
});

__metamagical_withMeta(Task.prototype['mapRejected'], {
  'name': 'mapRejected',
  'source': 'mapRejected(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  reason => resolver.reject(transformation(reason)),\r\n        onResolved:  resolver.resolve\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e1, e2, v:\n  (Task e1 v).((e1) => e2) => Task e2 v\n \n'
});

__metamagical_withMeta(Task.prototype['map'], {
  'name': 'map',
  'source': 'map(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  value => resolver.resolve(transformation(value))\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v1, v2:\n  (Task e v1).((v1) => v2) => Task e v2\n \n'
});

__metamagical_withMeta(Task.prototype['chain'], {
  'name': 'chain',
  'source': 'chain(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  value => {\r\n          transformation(value).run().listen({\r\n            onCancelled: resolver.cancel,\r\n            onRejected:  resolver.reject,\r\n            onResolved:  resolver.resolve\r\n          });\r\n        }\r\n      });\r\n    });\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v1, v2:\n  (Task e v1).((v1) => Task e v2) => Task e v2\n \n'
});

__metamagical_withMeta(Task.prototype['constructor'], {
  'name': 'constructor',
  'source': 'constructor(computation) {\r\n    this._computation = computation;\r\n  }',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall value, reason:\n  new (\n    ({\n       resolve: (value) => Void,\n       reject: (reason) => Void,\n       cancel: () => Void,\n       cleanup: (() => Void) => Void,\n       onCancelled: (() => Void) => Void,\n       get isCancelled: Boolean\n     }) => Void\n  ) => Task value reason\n \n'
});

__metamagical_withMeta(Task, {
  'name': 'Task',
  'source': 'class Task {\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall value, reason:\r\n   *     new (\r\n   *       ({\r\n   *          resolve: (value) => Void,\r\n   *          reject: (reason) => Void,\r\n   *          cancel: () => Void,\r\n   *          cleanup: (() => Void) => Void,\r\n   *          onCancelled: (() => Void) => Void,\r\n   *          get isCancelled: Boolean\r\n   *        }) => Void\r\n   *     ) => Task value reason\r\n   */\r\n  constructor(computation) {\r\n    this._computation = computation;\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e v1).((v1) => Task e v2) => Task e v2\r\n   */\r\n  chain(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  value => {\r\n          transformation(value).run().listen({\r\n            onCancelled: resolver.cancel,\r\n            onRejected:  resolver.reject,\r\n            onResolved:  resolver.resolve\r\n          });\r\n        }\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e v1).((v1) => v2) => Task e v2\r\n   */\r\n  map(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  value => resolver.resolve(transformation(value))\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e1, e2, v:\r\n   *     (Task e1 v).((e1) => e2) => Task e2 v\r\n   */\r\n  mapRejected(transformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  reason => resolver.reject(transformation(reason)),\r\n        onResolved:  resolver.resolve\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e ((v1) => v2)).(Task e v1) => Task e v2\r\n   */\r\n  apply(task) {\r\n    return this.chain(f => task.map(f));\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e1, e2, v1, v2:\r\n   *     (Task e1 v1).((e1) => e2, (v1) => v2) => Task e2 v2\r\n   */\r\n  bimap(rejectionTransformation, successTransformation) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  reason => resolver.reject(rejectionTransformation(reason)),\r\n        onResolved:  value => resolver.resolve(successTransformation(value))\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e1, e2, v1, v2:\r\n   *     type Pattern = { row |\r\n   *       Cancelled: ()  => Task e2 v2,\r\n   *       Resolved:  (b) => Task e2 v2,\r\n   *       Rejected:  (a) => Task e2 v2\r\n   *     }\r\n   *\r\n   *     (Task e1 v1).(Pattern) => Task e2 v2\r\n   */\r\n  willMatchWith(pattern) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n      \r\n      const resolve = (handler) => (value) => handler(value).run().listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.reject,\r\n        onResolved:  resolver.resolve\r\n      });\r\n      execution.listen({\r\n        onCancelled: resolve(_ => pattern.Cancelled()),\r\n        onRejected:  resolve(pattern.Rejected),\r\n        onResolved:  resolve(pattern.Resolved)\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v: (Task e v).() => Task v e\r\n   */\r\n  swap() {\r\n    return new Task(resolver => {\r\n      let execution = this.run();   // eslint-disable-line prefer-const\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onRejected:  resolver.resolve,\r\n        onResolved:  resolver.reject\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, e2, v:\r\n   *     (Task e v).((e) => Task e2 v) => Task e2 v\r\n   */\r\n  orElse(handler) {\r\n    return new Task(resolver => {\r\n      const execution = this.run();\r\n      resolver.onCancelled(() => execution.cancel());\r\n\r\n      execution.listen({\r\n        onCancelled: resolver.cancel,\r\n        onResolved:  resolver.resolve,\r\n        onRejected:  reason => {\r\n          handler(reason).run().listen({\r\n            onCancelled: resolver.cancel,\r\n            onRejected:  resolver.reject,\r\n            onResolved:  resolver.resolve\r\n          });\r\n        }\r\n      });\r\n    });\r\n  }\r\n\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v:\r\n   *     (Task e v).(Task e v) => Task e v\r\n   */\r\n  or(that) {\r\n    return new Task(resolver => {\r\n      let thisExecution = this.run();   // eslint-disable-line prefer-const\r\n      let thatExecution = that.run();   // eslint-disable-line prefer-const\r\n      let done = false;\r\n\r\n      resolver.onCancelled(() => {\r\n        thisExecution.cancel();\r\n        thatExecution.cancel();\r\n      });\r\n\r\n      const guard = (fn, execution) => (value) => {\r\n        if (!done) {\r\n          done = true;\r\n          execution.cancel();\r\n          fn(value);\r\n        }\r\n      };\r\n\r\n      thisExecution.listen({\r\n        onRejected:  guard(resolver.reject, thatExecution),\r\n        onCancelled: guard(resolver.cancel, thatExecution),\r\n        onResolved:  guard(resolver.resolve, thatExecution)\r\n      });\r\n\r\n      thatExecution.listen({\r\n        onRejected:  guard(resolver.reject, thisExecution),\r\n        onCancelled: guard(resolver.cancel, thisExecution),\r\n        onResolved:  guard(resolver.resolve, thisExecution)\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v1, v2:\r\n   *     (Task e v1).(Task e v2) => Task e (v1, v2)\r\n   */\r\n  and(that) {\r\n    return new Task(resolver => {   // eslint-disable-line max-statements\r\n      let thisExecution = this.run();   // eslint-disable-line prefer-const\r\n      let thatExecution = that.run();   // eslint-disable-line prefer-const\r\n      let valueLeft = null;\r\n      let valueRight = null;\r\n      let doneLeft = false;\r\n      let doneRight = false;\r\n      let cancelled = false;\r\n\r\n      resolver.onCancelled(() => {\r\n        thisExecution.cancel();\r\n        thatExecution.cancel();\r\n      });\r\n\r\n      const guardResolve = (setter) => (value) => {\r\n        if (cancelled)  return;\r\n\r\n        setter(value);\r\n        if (doneLeft && doneRight) {\r\n          resolver.resolve([valueLeft, valueRight]);\r\n        }\r\n      };\r\n\r\n      const guardRejection = (fn, execution) => (value) => {\r\n        if (cancelled)  return;\r\n\r\n        cancelled = true;\r\n        execution.cancel();\r\n        fn(value);\r\n      };\r\n\r\n      thisExecution.listen({\r\n        onRejected:  guardRejection(resolver.reject, thatExecution),\r\n        onCancelled: guardRejection(resolver.cancel, thatExecution),\r\n        onResolved:  guardResolve(x => {\r\n          valueLeft = x;\r\n          doneLeft = true;\r\n        })\r\n      });\r\n\r\n      thatExecution.listen({\r\n        onRejected:  guardRejection(resolver.reject, thisExecution),\r\n        onCancelled: guardRejection(resolver.cancel, thisExecution),\r\n        onResolved:  guardResolve(x => {\r\n          valueRight = x;\r\n          doneRight = true;\r\n        })\r\n      });\r\n    });\r\n  }\r\n\r\n  /*~\r\n   * stability: experimental\r\n   * type: |\r\n   *   forall e, v: (Task e v).() => TaskExecution e v\r\n   */\r\n  run() {\r\n    let deferred = new Deferred();    // eslint-disable-line prefer-const\r\n    let cleanups      = [];\r\n    let cancellations = [];\r\n    let isCancelled   = false;\r\n    let done          = false;\r\n\r\n    deferred.listen({\r\n      onCancelled: _ => {\r\n        done = true;\r\n        isCancelled = true;\r\n        cancellations.forEach(f => f());\r\n        cleanups.forEach(f => f());\r\n        cancellations = [];\r\n        cleanups = [];\r\n      },\r\n\r\n      onResolved: _value => {\r\n        done = true;\r\n        cleanups.forEach(f => f());\r\n        cleanups = [];\r\n        cancellations = [];\r\n      },\r\n\r\n      onRejected: _reason => {\r\n        done = true;\r\n        cleanups.forEach(f => f());\r\n        cleanups = [];\r\n        cancellations = [];\r\n      }\r\n    });\r\n\r\n    const resources = this._computation({\r\n      reject:  error => { deferred.reject(error) },\r\n      resolve: value => { deferred.resolve(value) },\r\n      cancel:  _     => { deferred.maybeCancel() },\r\n\r\n      get isCancelled() { return isCancelled },\r\n      cleanup(f) {\r\n        if (done) {\r\n          throw new Error(\'Can\\\'t attach a cleanup handler after the task is settled.\');\r\n        }\r\n        cleanups.push(f);\r\n      },\r\n      onCancelled(f) {\r\n        if (done) {\r\n          throw new Error(\'Can\\\'t attach a cancellation handler after the task is settled.\');\r\n        }\r\n        cancellations.push(f);\r\n      }\r\n    });\r\n\r\n    return new TaskExecution(this, deferred);\r\n  }\r\n}',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 20,
      'column': 0
    },
    'end': {
      'line': 362,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental'
});

Object.assign(Task, (_Object$assign = {
  of: function of(value) {
    return new Task(function (resolver) {
      return resolver.resolve(value);
    });
  },
  rejected: function rejected(reason) {
    return new Task(function (resolver) {
      return resolver.reject(reason);
    });
  }
}, __metamagical_withMeta(_Object$assign['of'], {
  'name': 'of',
  'source': 'of(value) {\r\n    return new Task(resolver => resolver.resolve(value));\r\n  }',
  'signature': 'of(value)',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 365,
      'column': 20
    },
    'end': {
      'line': 383,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v: (v) => Task e v\n \n'
}), __metamagical_withMeta(_Object$assign['rejected'], {
  'name': 'rejected',
  'source': 'rejected(reason) {\r\n    return new Task(resolver => resolver.reject(reason));\r\n  }',
  'signature': 'rejected(reason)',
  'location': {
    'filename': 'source/concurrency/task/_task.js',
    'start': {
      'line': 365,
      'column': 20
    },
    'end': {
      'line': 383,
      'column': 1
    }
  },
  'module': 'folktale/concurrency/task/_task',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall e, v: (e) => Task e v\n \n'
}), _Object$assign));

provideAliases(Task);
provideAliases(Task.prototype);

module.exports = Task;