'use strict';

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var Task = require('./_task');

/*~
 * stability: experimental
 * type: |
 *   forall v, e: (GeneratorInstance [Task e v Any]) => Any => Task e [v] Any
 */
var nextGeneratorValue = function nextGeneratorValue(generator) {
  return function (value) {
    var _generator$next = generator.next(value),
        task = _generator$next.value,
        done = _generator$next.done;

    return !done ? task.chain(nextGeneratorValue(generator)
    /* else */) : task;
  };
};

/*~
 * stability: experimental
 * type: |
 *   forall v, e: (Generator [Task e v Any]) => Task e [v] Any
 */
var taskDo = function taskDo(generatorFn) {
  return new Task(function (resolver) {
    return resolver.resolve(generatorFn());
  }).chain(function (generator) {
    return nextGeneratorValue(generator)();
  });
};

module.exports = taskDo;