'use strict';

var __metamagical_withMeta = function metamagical_withMeta(object, meta) {
  var parent = Object.getPrototypeOf(object);var oldMeta = object[Symbol.for('@@meta:magical')] || {};if (parent && parent[Symbol.for('@@meta:magical')] === oldMeta) {
    oldMeta = {};
  }Object.keys(meta).forEach(function (key) {
    if (/^~/.test(key)) {
      oldMeta[key.slice(1)] = meta[key];
    } else {
      oldMeta[key] = meta[key];
    }
  });object[Symbol.for('@@meta:magical')] = oldMeta;return object;
};

//----------------------------------------------------------------------
//
// This source file is part of the Folktale project.
//
// Licensed under MIT. See LICENCE for full licence information.
// See CONTRIBUTORS for the list of contributors to the project.
//
//----------------------------------------------------------------------

var Task = require('./_task');

/*~
 * stability: experimental
 * type: |
 *   forall v, e: (GeneratorInstance [Task e v Any]) => Any => Task e [v] Any
 */
var nextGeneratorValue = __metamagical_withMeta(function (generator) {
  return function (value) {
    var _generator$next = generator.next(value),
        task = _generator$next.value,
        done = _generator$next.done;

    return !done ? task.chain(nextGeneratorValue(generator)
    /* else */) : task;
  };
}, {
  'name': 'nextGeneratorValue',
  'source': '(generator) => (value) => {\n  const { value: task, done } = generator.next(value);\n  return !done ? task.chain(nextGeneratorValue(generator))\n    /* else */ : task;\n}',
  'signature': 'nextGeneratorValue(generator)',
  'location': {
    'filename': 'source/concurrency/task/do.js',
    'start': {
      'line': 17,
      'column': 0
    },
    'end': {
      'line': 21,
      'column': 2
    }
  },
  'module': 'folktale/concurrency/task/do',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall v, e: (GeneratorInstance [Task e v Any]) => Any => Task e [v] Any\n'
});

/*~
 * stability: experimental
 * type: |
 *   forall v, e: (Generator [Task e v Any]) => Task e [v] Any
 */
var taskDo = __metamagical_withMeta(function (generatorFn) {
  return new Task(function (resolver) {
    return resolver.resolve(generatorFn());
  }).chain(function (generator) {
    return nextGeneratorValue(generator)();
  });
}, {
  'name': 'taskDo',
  'source': '(generatorFn) => \n  new Task((resolver) => resolver.resolve(generatorFn()))\n    .chain((generator) => nextGeneratorValue(generator)())',
  'signature': 'taskDo(generatorFn)',
  'location': {
    'filename': 'source/concurrency/task/do.js',
    'start': {
      'line': 28,
      'column': 0
    },
    'end': {
      'line': 30,
      'column': 59
    }
  },
  'module': 'folktale/concurrency/task/do',
  'licence': 'MIT',
  'authors': ['Quildreen Motta'],
  'repository': 'https://github.com/origamitower/folktale',
  'npmPackage': 'folktale',
  'copyright': '(c) 2013-2017 Quildreen Motta, and CONTRIBUTORS',
  'maintainers': ['Quildreen Motta <queen@robotlolita.me> (http://robotlolita.me/)'],
  'stability': 'experimental',
  'type': 'forall v, e: (Generator [Task e v Any]) => Task e [v] Any\n'
});

module.exports = taskDo;