// Generated by CoffeeScript 1.10.0
(function() {
  var CompiledCache, StringStream, _, coffeeCoverage, excludeFile, fs, getRelativeFilename, mkdirs, path, ref;

  path = require('path');

  fs = require('fs');

  _ = require('lodash');

  coffeeCoverage = require('./coffeeCoverage');

  CompiledCache = require('./CompiledCache');

  StringStream = (function() {
    function StringStream() {
      this.data = "";
    }

    StringStream.prototype.write = function(data) {
      return this.data += data;
    };

    return StringStream;

  })();

  ref = require('./utils/helpers'), mkdirs = ref.mkdirs, excludeFile = ref.excludeFile, getRelativeFilename = ref.getRelativeFilename;

  module.exports = function(options) {
    var compiledCache, coverage, defaults, err, error, instrumentFile, instrumentorClass, module, origStreamineCoffeeHandler, replaceHandler, streamlineTransform;
    if (options == null) {
      options = {};
    }
    options = _.defaults({}, options, {
      instrumentor: 'jscoverage',
      exclude: [],
      basePath: null,
      initFileStream: null,
      initAll: false,
      writeOnExit: null,
      streamlinejs: false,
      postProcessors: [],
      cachePath: null
    });
    instrumentorClass = coffeeCoverage.INSTRUMENTORS[options.instrumentor];
    if (!instrumentorClass) {
      throw new Error(("Unknown instrumentor: " + options.instrumentor + ".  ") + ("Valid options are " + (Object.keys(coffeeCoverage.INSTRUMENTORS))));
    }
    if (instrumentorClass.getDefaultOptions != null) {
      defaults = instrumentorClass.getDefaultOptions();
      options = _.defaults(options, defaults);
    }
    if (options.basePath) {
      options.basePath = path.resolve(options.basePath);
    }
    if (options.cachePath) {
      options.cachePath = path.resolve(options.cachePath);
    }
    compiledCache = new CompiledCache(options.basePath, options.cachePath);
    coverage = new coffeeCoverage.CoverageInstrumentor(options);
    module = require('module');
    if (options.basePath && options.initAll) {
      options.initFileStream = new StringStream();
      coverage.instrumentDirectory(options.basePath, null, options);
      eval(options.initFileStream.data);
    }
    instrumentFile = function(fileName) {
      var content, instrumented;
      content = fs.readFileSync(fileName, 'utf8');
      instrumented = coverage.instrumentCoffee(fileName, content);
      return instrumented.init + instrumented.js;
    };
    replaceHandler = function(extension) {
      var origCoffeeHandler;
      origCoffeeHandler = require.extensions[extension];
      return require.extensions[extension] = function(module, fileName) {
        var compiled;
        if (excludeFile(fileName, options)) {
          return origCoffeeHandler.call(this, module, fileName);
        }
        compiled = compiledCache.get(fileName, function() {
          return instrumentFile(fileName);
        });
        return module._compile(compiled, fileName);
      };
    };
    replaceHandler(".coffee");
    replaceHandler(".litcoffee");
    replaceHandler(".coffee.md");
    if (options.streamlinejs) {
      console.warn("\noptions.streamlinejs is deprecated. Please use options.postProcessors\n");
      try {
        streamlineTransform = require('streamline/lib/callbacks/transform');
      } catch (error) {
        err = error;
        throw new Error("Could not load streamline transformer < 1.x");
      }
      origStreamineCoffeeHandler = require.extensions["._coffee"];
      require.extensions["._coffee"] = function(module, fileName) {
        var transformed;
        if (excludeFile(fileName, options)) {
          return origStreamineCoffeeHandler.call(this, module, fileName);
        }
        transformed = compiledCache.get(fileName, function() {
          var compiled, streamlineOptions;
          compiled = instrumentFile(fileName);
          streamlineOptions = _.isObject(options.streamlinejs) ? options.streamlinejs : {};
          streamlineOptions = _.assign({}, streamlineOptions, {
            sourceName: fileName
          });
          transformed = streamlineTransform.transform(compiled, streamlineOptions);
          return transformed;
        });
        return module._compile(transformed, fileName);
      };
    }
    if (_.isArray(options.postProcessors) && options.postProcessors.length) {
      options.postProcessors.forEach(function(processorOpts) {
        var ext, fn, originalHandler;
        if (processorOpts == null) {
          processorOpts = {};
        }
        ext = processorOpts.ext, fn = processorOpts.fn;
        if (!(_.isString(ext) && _.isFunction(fn))) {
          return;
        } else if ("._coffee" === ext && options.streamlinejs) {
          return;
        }
        originalHandler = require.extensions[ext];
        return require.extensions[ext] = function(module, fileName) {
          var processed;
          if (excludeFile(fileName, options)) {
            return originalHandler.call(this, module, fileName);
          }
          processed = compiledCache.get(fileName, function() {
            var compiled;
            compiled = instrumentFile(fileName);
            return fn(compiled, fileName);
          });
          return module._compile(processed, fileName);
        };
      });
    }
    if (options.writeOnExit) {
      return process.on('exit', function() {
        var dirName, error1, ref1;
        try {
          dirName = path.dirname(options.writeOnExit);
          mkdirs(dirName);
          return fs.writeFileSync(options.writeOnExit, JSON.stringify(global[options.coverageVar]));
        } catch (error1) {
          err = error1;
          return console.error("Failed to write coverage data", (ref1 = err.stack) != null ? ref1 : err);
        }
      });
    }
  };

}).call(this);
