// Generated by CoffeeScript 1.10.0
(function() {
  var JSCoverage, _, fileToLines, generateUniqueName, getRelativeFilename, path, ref, stripLeadingDotOrSlash, toQuotedString,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  path = require('path');

  _ = require('lodash');

  ref = require('../utils/helpers'), toQuotedString = ref.toQuotedString, stripLeadingDotOrSlash = ref.stripLeadingDotOrSlash, getRelativeFilename = ref.getRelativeFilename;

  fileToLines = require('../utils/codeUtils').fileToLines;

  generateUniqueName = function(usedNames, desiredName) {
    var answer, suffix;
    answer = "";
    suffix = 1;
    while (true) {
      answer = desiredName + " (" + suffix + ")";
      if (!(indexOf.call(usedNames, answer) >= 0)) {
        break;
      }
      suffix++;
    }
    return answer;
  };

  module.exports = JSCoverage = (function() {
    JSCoverage.getDefaultOptions = function() {
      return {
        path: 'bare',
        usedFileNameMap: {},
        coverageVar: '_$jscoverage'
      };
    };

    function JSCoverage(fileName, source, options) {
      var ref1, relativeFileName;
      this.fileName = fileName;
      this.source = source;
      if (options == null) {
        options = {};
      }
      this.log = options.log, this.coverageVar = options.coverageVar;
      options = _.defaults({}, options, JSCoverage.getDefaultOptions());
      this.instrumentedLines = [];
      relativeFileName = getRelativeFilename(options.basePath, this.fileName);
      this.shortFileName = ((ref1 = options.usedFileNameMap) != null ? ref1[this.fileName] : void 0) || (function(_this) {
        return function() {
          var shortFileName, usedFileNames;
          shortFileName = (function() {
            switch (options.path) {
              case 'relative':
                return stripLeadingDotOrSlash(relativeFileName);
              case 'abbr':
                return this._abbreviatedPath(stripLeadingDotOrSlash(relativeFileName));
              default:
                return path.basename(relativeFileName);
            }
          }).call(_this);
          if (options.usedFileNames != null) {
            if (indexOf.call(options.usedFileNames, shortFileName) >= 0) {
              shortFileName = generateUniqueName(options.usedFileNames, shortFileName);
            }
            options.usedFileNames.push(shortFileName);
          } else if (options.usedFileNameMap != null) {
            usedFileNames = _.values(options.usedFileNameMap);
            if (indexOf.call(usedFileNames, shortFileName) >= 0) {
              shortFileName = generateUniqueName(usedFileNames, shortFileName);
            }
            options.usedFileNameMap[_this.fileName] = shortFileName;
          }
          return shortFileName;
        };
      })(this)();
      this.quotedFileName = toQuotedString(this.shortFileName);
    }

    JSCoverage.prototype._abbreviatedPath = function(pathName) {
      var answer, filename, i, len, needTrailingSlash, pathElement, splitPath;
      needTrailingSlash = false;
      splitPath = pathName.split(path.sep);
      if (splitPath.slice(-1)[0] === '') {
        needTrailingSlash = true;
        splitPath.pop();
      }
      filename = splitPath.pop();
      answer = "";
      for (i = 0, len = splitPath.length; i < len; i++) {
        pathElement = splitPath[i];
        if (pathElement.length === 0) {
          answer += "";
        } else if (pathElement === "..") {
          answer += pathElement;
        } else if (_.startsWith(pathElement, ".")) {
          answer += pathElement.slice(0, 2);
        } else {
          answer += pathElement[0];
        }
        answer += path.sep;
      }
      answer += filename;
      if (needTrailingSlash) {
        answer += path.sep;
      }
      return answer;
    };

    JSCoverage.prototype.visitStatement = function(node) {
      var line, ref1, ref2;
      if (node.isMarked('skip') || node.isMarked('noCoverage')) {
        return;
      }
      line = node.locationData.first_line + 1;
      if (indexOf.call(this.instrumentedLines, line) >= 0) {
        return (ref1 = this.log) != null ? typeof ref1.debug === "function" ? ref1.debug("Skipping   " + (node.toString())) : void 0 : void 0;
      } else {
        if ((ref2 = this.log) != null) {
          if (typeof ref2.debug === "function") {
            ref2.debug("Instrumenting " + (node.toString()));
          }
        }
        this.instrumentedLines.push(line);
        return node.insertBefore(this.coverageVar + "[" + this.quotedFileName + "][" + line + "]++");
      }
    };

    JSCoverage.prototype.visitIf = function(node) {
      var ref1;
      if (node.node.isChain) {
        if ((ref1 = this.log) != null) {
          if (typeof ref1.debug === "function") {
            ref1.debug("  Disabling chaining for if statement");
          }
        }
        return node.node.isChain = false;
      }
    };

    JSCoverage.prototype.getInitString = function() {
      var fileToInstrumentLines, i, index, init, j, len, len1, line, lineNumber, ref1;
      init = "if (typeof " + this.coverageVar + " === 'undefined') " + this.coverageVar + " = {};\n(function(_export) {\n    if (typeof _export." + this.coverageVar + " === 'undefined') {\n        _export." + this.coverageVar + " = " + this.coverageVar + ";\n    }\n})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : this);\nif (! " + this.coverageVar + "[" + this.quotedFileName + "]) {\n    " + this.coverageVar + "[" + this.quotedFileName + "] = [];\n";
      ref1 = this.instrumentedLines;
      for (i = 0, len = ref1.length; i < len; i++) {
        lineNumber = ref1[i];
        init += "    " + this.coverageVar + "[" + this.quotedFileName + "][" + lineNumber + "] = 0;\n";
      }
      init += "}\n\n";
      init += this.coverageVar + "[" + this.quotedFileName + "].source = [";
      fileToInstrumentLines = fileToLines(this.source);
      for (index = j = 0, len1 = fileToInstrumentLines.length; j < len1; index = ++j) {
        line = fileToInstrumentLines[index];
        if (!!index) {
          init += ", ";
        }
        init += toQuotedString(line);
      }
      return init += "];\n\n";
    };

    JSCoverage.prototype.getInstrumentedLineCount = function() {
      return this.instrumentedLines.length;
    };

    return JSCoverage;

  })();

}).call(this);
