// Generated by CoffeeScript 1.10.0
(function() {
  var Istanbul, NodeWrapper, _, assert, compareLocations, fileToLines, findInCode, minLocation, nodeToLocation, ref, toQuotedString;

  assert = require('assert');

  _ = require('lodash');

  NodeWrapper = require('../NodeWrapper');

  toQuotedString = require('../utils/helpers').toQuotedString;

  ref = require('../utils/codeUtils'), compareLocations = ref.compareLocations, fileToLines = ref.fileToLines, minLocation = ref.minLocation;

  nodeToLocation = function(node) {
    var answer, ref1;
    answer = {
      start: {
        line: node.locationData.first_line + 1,
        column: node.locationData.first_column
      },
      end: {
        line: node.locationData.last_line + 1,
        column: node.locationData.last_column
      }
    };
    if (((ref1 = node.coffeeCoverage) != null ? ref1.skip : void 0) || (typeof node.isMarked === "function" ? node.isMarked('skip') : void 0)) {
      answer.skip = true;
    }
    return answer;
  };

  findInCode = function(code, str, options) {
    var column, currentCol, currentLine, end, ref1, ref2, start;
    if (options == null) {
      options = {};
    }
    start = (ref1 = options.start) != null ? ref1 : {
      line: 1,
      column: 0
    };
    end = (ref2 = options.end) != null ? ref2 : {
      line: code.length + 1,
      column: 0
    };
    currentLine = start.line;
    currentCol = start.column;
    while (currentLine < end.line) {
      column = code[currentLine - 1].indexOf(str, currentCol);
      if (column > -1 && compareLocations({
        line: currentLine,
        column: column
      }, end) < 1) {
        return {
          line: currentLine,
          column: column
        };
      }
      currentLine++;
      currentCol = 0;
    }
    return null;
  };

  module.exports = Istanbul = (function() {
    Istanbul.getDefaultOptions = function() {
      var ref1;
      return {
        coverageVar: (ref1 = module.exports.findIstanbulVariable()) != null ? ref1 : '_$coffeeIstanbul'
      };
    };

    Istanbul.findIstanbulVariable = function() {
      var coverageVar, coverageVars;
      coverageVar = "$$cov_" + (Date.now()) + "$$";
      if (global[coverageVar] == null) {
        coverageVars = Object.keys(global).filter(function(key) {
          return _.startsWith(key, '$$cov_');
        });
        if (coverageVars.length === 1) {
          coverageVar = coverageVars[0];
        } else {
          coverageVar = void 0;
        }
      }
      return coverageVar;
    };

    function Istanbul(fileName, source, options) {
      this.fileName = fileName;
      this.source = source;
      if (options == null) {
        options = {};
      }
      this.log = options.log, this.coverageVar = options.coverageVar;
      options = _.defaults({}, options, Istanbul.getDefaultOptions());
      this.sourceLines = fileToLines(this.source);
      this.quotedFileName = toQuotedString(this.fileName);
      this.statementMap = [];
      this.branchMap = [];
      this.fnMap = [];
      this.instrumentedLineCount = 0;
      this.anonId = 1;
      this._prefix = this.coverageVar + "[" + this.quotedFileName + "]";
    }


    /* !pragma coverage-skip-next */

    Istanbul.prototype._warn = function(message, options) {
      var lineNumber, ref1, str;
      if (options == null) {
        options = {};
      }
      str = message;
      str += "\n    file:  " + this.fileName;
      if (options.node) {
        str += "\n    node:  " + (options.node.toString());
      }
      if ((options.line != null) || options.node) {
        lineNumber = options.line != null ? options.line : options.node.locationData.first_line + 1;
        str += "\n    source: " + this.sourceLines[lineNumber - 1];
      }
      return (ref1 = this.log) != null ? ref1.warn(str) : void 0;
    };

    Istanbul.prototype.visitStatement = function(node) {
      var location, statementId;
      if (node.isMarked('noCoverage')) {
        return;
      }
      statementId = this.statementMap.length + 1;
      location = nodeToLocation(node);
      if (node.type === 'If') {
        location.end = this._findEndOfIf(node);
      }
      this.statementMap.push(location);
      node.insertBefore(this._prefix + ".s[" + statementId + "]++");
      return this.instrumentedLineCount++;
    };

    Istanbul.prototype._findEndOfIf = function(ifNode) {
      var elseBody, elseChild;
      assert(ifNode.type === 'If');
      elseBody = ifNode.child('elseBody');
      if (ifNode.node.isChain || ifNode.isMarked('wasChain')) {
        assert(elseBody != null);
        elseChild = elseBody.child('expressions', 0);
        assert(elseChild.type === 'If');
        return this._findEndOfIf(elseChild);
      } else if (elseBody != null) {
        return nodeToLocation(elseBody).end;
      } else {
        return nodeToLocation(ifNode).end;
      }
    };

    Istanbul.prototype.visitIf = function(node) {
      var body, bodyPresent, branchId, elseBody, elseBodyPresent, elseLocation, ifLocation, ref1;
      if (node.isMarked('noCoverage')) {
        return;
      }
      branchId = this.branchMap.length + 1;
      ifLocation = nodeToLocation(node);
      ifLocation.end.line = ifLocation.start.line;
      ifLocation.end.column = ifLocation.start.column;
      elseLocation = ifLocation;
      if (!ifLocation.skip) {
        elseLocation = _.clone(ifLocation);
        if (node.isMarked('skipIf')) {
          ifLocation.skip = true;
        }
        if (node.isMarked('skipElse')) {
          elseLocation.skip = true;
        }
      }
      if (node.node.isChain) {
        if ((ref1 = this.log) != null) {
          if (typeof ref1.debug === "function") {
            ref1.debug("  Disabling chaining for if statement");
          }
        }
        node.node.isChain = false;
        node.mark('wasChain', true);
      }
      body = node.child('body');
      elseBody = node.child('elseBody');
      bodyPresent = body && body.node.expressions.length > 0;
      elseBodyPresent = elseBody && elseBody.node.expressions.length > 0;
      if (node.parent.type === 'Return' && (!bodyPresent || !elseBodyPresent)) {
        if (bodyPresent && !elseBodyPresent) {
          node.insertAtStart('body', this._prefix + ".b[" + branchId + "][0]++");
          node.parent.insertAfter(this._prefix + ".b[" + branchId + "][1]++");
          this.instrumentedLineCount += 2;
        } else if (elseBodyPresent && !bodyPresent) {
          node.insertAtStart('elseBody', this._prefix + ".b[" + branchId + "][1]++");
          node.parent.insertAfter(this._prefix + ".b[" + branchId + "][0]++");
          this.instrumentedLineCount += 2;
        } else if (!elseBodyPresent && !bodyPresent) {
          this._warn("If statement could not be instrumented", {
            node: node
          });
          ifLocation.skip = true;
          elseLocation.skip = true;
        }
      } else {
        if (!bodyPresent) {
          node.insertAtStart('body', "undefined");
        }
        if (!elseBodyPresent) {
          node.insertAtStart('elseBody', "undefined");
        }
        node.insertAtStart('body', this._prefix + ".b[" + branchId + "][0]++");
        node.insertAtStart('elseBody', this._prefix + ".b[" + branchId + "][1]++");
        this.instrumentedLineCount += 2;
      }
      return this.branchMap.push({
        line: ifLocation.start.line,
        type: 'if',
        locations: [ifLocation, elseLocation]
      });
    };

    Istanbul.prototype.visitSwitch = function(node) {
      var branchId, locations;
      if (node.isMarked('noCoverage')) {
        return;
      }
      branchId = this.branchMap.length + 1;
      locations = [];
      locations = node.node.cases.map((function(_this) {
        return function(arg) {
          var answer, block, blockLocation, conditions, ref1, start, startColumn;
          conditions = arg[0], block = arg[1];
          start = minLocation(_.flatten([conditions], true).map(function(condition) {
            return nodeToLocation(condition).start;
          }));
          blockLocation = nodeToLocation(block);
          if ((startColumn = (ref1 = _this.sourceLines[start.line - 1]) != null ? ref1.indexOf('when') : void 0) > -1) {
            start.column = startColumn;
          } else {

            /* !pragma coverage-skip-block */
            _this._warn("Couldn't find 'when'", {
              node: node,
              line: start.line
            });
            start.column -= 5;
            if (start.column < 0) {
              start.column = 0;
            }
          }
          answer = {
            start: start,
            end: blockLocation.end
          };
          if (node.isMarked('skip') || blockLocation.skip) {
            answer.skip = true;
          }
          return answer;
        };
      })(this));
      if (node.node.otherwise != null) {
        locations.push(nodeToLocation(node.node.otherwise));
      }
      this.branchMap.push({
        line: nodeToLocation(node).start.line,
        type: 'switch',
        locations: locations
      });
      node.node.cases.forEach((function(_this) {
        return function(arg, index) {
          var block, caseNode, conditions;
          conditions = arg[0], block = arg[1];
          caseNode = new NodeWrapper(block, node, 'cases', index, node.depth + 1);
          assert.equal(caseNode.type, 'Block');
          return caseNode.insertAtStart('expressions', _this._prefix + ".b[" + branchId + "][" + index + "]++");
        };
      })(this));
      return node.forEachChildOfType('otherwise', (function(_this) {
        return function(otherwise) {
          var index;
          index = node.node.cases.length;
          assert.equal(otherwise.type, 'Block');
          return otherwise.insertAtStart('expressions', _this._prefix + ".b[" + branchId + "][" + index + "]++");
        };
      })(this));
    };

    Istanbul.prototype.visitCode = function(node) {
      var arrow, end, endOfFn, fnMapEntry, functionId, isAssign, lastParam, loc, name, paramCount, ref1, ref2, ref3, ref4, ref5, start;
      if (node.isMarked('noCoverage')) {
        return;
      }
      functionId = this.fnMap.length + 1;
      paramCount = (ref1 = (ref2 = node.node.params) != null ? ref2.length : void 0) != null ? ref1 : 0;
      isAssign = node.parent.type === 'Assign' && (((ref3 = node.parent.node.variable) != null ? (ref4 = ref3.base) != null ? ref4.value : void 0 : void 0) != null);
      name = isAssign ? node.parent.node.variable.base.value : "(anonymous_" + (this.anonId++) + ")";
      start = isAssign ? nodeToLocation(node.parent).start : nodeToLocation(node).start;
      if (paramCount > 0) {
        lastParam = node.child('params', paramCount - 1);
        end = nodeToLocation(lastParam).end;
        arrow = node.node.bound ? '=>' : '->';
        endOfFn = findInCode(this.sourceLines, arrow, {
          start: {
            line: end.line,
            column: end.column
          },
          end: nodeToLocation(node).end
        });
        if (endOfFn) {
          end = endOfFn;
          end.column += 1;
        } else {

          /* !pragma coverage-skip-block */
          this._warn("Couldn't find '->' or '=>'", {
            node: node,
            line: start.line
          });
          end.column += 4;
        }
      } else {
        end = nodeToLocation(node).start;
        end.column++;
      }
      loc = {
        start: start,
        end: end
      };
      fnMapEntry = {
        name: name,
        line: start.line,
        loc: loc
      };
      if ((ref5 = node.node.coffeeCoverage) != null ? ref5.skip : void 0) {
        fnMapEntry.skip = true;
      }
      this.fnMap.push(fnMapEntry);
      return node.insertAtStart('body', this._prefix + ".f[" + functionId + "]++");
    };

    Istanbul.prototype.visitClass = function(node) {
      var functionId, loc, ref1;
      if (node.isMarked('noCoverage')) {
        return;
      }
      functionId = this.fnMap.length + 1;
      if (node.node.variable != null) {
        loc = nodeToLocation(node.node.variable);
      } else {
        loc = nodeToLocation(node);
        loc.end = loc.start;
      }
      this.fnMap.push({
        name: (ref1 = node.node.determineName()) != null ? ref1 : '(anonymousClass)',
        line: loc.start.line,
        loc: loc
      });
      return node.insertAtStart('body', this._prefix + ".f[" + functionId + "]++");
    };

    Istanbul.prototype.getInitString = function() {
      var init, initData;
      initData = {
        path: this.fileName,
        s: {},
        b: {},
        f: {},
        fnMap: {},
        statementMap: {},
        branchMap: {}
      };
      this.statementMap.forEach((function(_this) {
        return function(statement, id) {
          initData.s[id + 1] = 0;
          return initData.statementMap[id + 1] = statement;
        };
      })(this));
      this.branchMap.forEach((function(_this) {
        return function(branch, id) {
          initData.b[id + 1] = (function() {
            var i, ref1, results;
            results = [];
            for (i = 0, ref1 = branch.locations.length; 0 <= ref1 ? i < ref1 : i > ref1; 0 <= ref1 ? i++ : i--) {
              results.push(0);
            }
            return results;
          })();
          return initData.branchMap[id + 1] = branch;
        };
      })(this));
      this.fnMap.forEach((function(_this) {
        return function(fn, id) {
          initData.f[id + 1] = 0;
          return initData.fnMap[id + 1] = fn;
        };
      })(this));
      return init = "if (typeof " + this.coverageVar + " === 'undefined') " + this.coverageVar + " = {};\n(function(_export) {\n    if (typeof _export." + this.coverageVar + " === 'undefined') {\n        _export." + this.coverageVar + " = " + this.coverageVar + ";\n    }\n})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : this);\nif (! " + this._prefix + ") { " + this._prefix + " = " + (JSON.stringify(initData)) + " }";
    };

    Istanbul.prototype.getInstrumentedLineCount = function() {
      return this.instrumentedLineCount;
    };

    return Istanbul;

  })();

}).call(this);
