// Generated by CoffeeScript 1.9.2
(function() {
  var EXTENSIONS, _, assert, coffeeScript, fs, path, statFile,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  assert = require('assert');

  fs = require('fs');

  path = require('path');

  coffeeScript = require('coffee-script');

  _ = require('lodash');

  EXTENSIONS = require('./constants').EXTENSIONS;

  exports.stripLeadingDotOrSlash = function(pathName) {
    return pathName.replace(/^\//, "").replace(/^\.\//, "");
  };

  exports.statFile = statFile = function(file) {
    if (!fs.existsSync(file)) {
      return null;
    }
    return fs.statSync(file);
  };

  exports.mkdirs = function(dirPath, mode) {
    var currentPath, i, len, pathElement, pathElements, stat;
    if (!statFile(dirPath)) {
      pathElements = dirPath.split(path.sep);
      if (_.last(pathElements) === '') {
        pathElements.pop();
      }
      currentPath = "";
      for (i = 0, len = pathElements.length; i < len; i++) {
        pathElement = pathElements[i];
        currentPath += pathElement + path.sep;
        stat = statFile(currentPath);
        if (stat && !stat.isDirectory()) {
          throw new CoverageError("Can't create directory " + currentPath + ": file already exists.");
        }
        if (!stat) {
          fs.mkdirSync(currentPath, mode);
        }
      }
      return true;
    }
    return false;
  };

  exports.getRelativeFilename = function(basePath, fileName) {
    if ((basePath != null) && _.startsWith(fileName, basePath)) {
      fileName = path.relative(basePath, fileName);
    }
    return fileName;
  };

  exports.excludeFile = function(fileName, options) {
    var basePath, component, components, exclude, excludePath, excluded, i, j, k, len, len1, len2, ref, relativeFilename, resolvedFileName;
    basePath = options.basePath;
    exclude = options.exclude;
    resolvedFileName = path.resolve(fileName);
    assert(resolvedFileName === fileName);
    if (!exclude) {
      return;
    }
    excluded = false;
    if (basePath) {
      relativeFilename = exports.getRelativeFilename(basePath, fileName);
      if (relativeFilename === fileName) {
        excluded = true;
      }
      components = relativeFilename.split(path.sep);
      for (i = 0, len = components.length; i < len; i++) {
        component = components[i];
        if (indexOf.call(exclude, component) >= 0) {
          excluded = true;
        }
      }
      if (!excluded) {
        for (j = 0, len1 = exclude.length; j < len1; j++) {
          excludePath = exclude[j];
          if (_.startsWith("/" + relativeFilename, excludePath) || _.startsWith(relativeFilename, excludePath)) {
            excluded = true;
          }
        }
      }
    }
    if (!excluded && (ref = !path.extname(fileName), indexOf.call(Object.keys(EXTENSIONS), ref) >= 0)) {
      excluded = true;
    }
    if (!excluded) {
      for (k = 0, len2 = exclude.length; k < len2; k++) {
        excludePath = exclude[k];
        if (_.startsWith(fileName, excludePath)) {
          excluded = true;
        }
      }
    }
    return excluded;
  };

  exports.toQuotedString = function(string) {
    var answer;
    answer = string.replace(/\\/g, '\\\\');
    return '"' + (answer.replace(/"/g, '\\\"')) + '"';
  };

  exports.fileToLines = function(source) {
    var dataWithFixedLfs;
    dataWithFixedLfs = source.replace(/\r\n/g, '\n').replace(/\r/g, '\n');
    return dataWithFixedLfs.split("\n");
  };

}).call(this);
