// Generated by CoffeeScript 1.10.0
(function() {
  var CoverageError, EXTENSIONS, INSTRUMENTORS, NodeWrapper, SkipVisitor, _, assert, coffeeScript, events, excludeFile, factoryDefaults, fs, getInstrumentorClass, mkdirs, path, ref, statFile, util,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  assert = require('assert');

  events = require('events');

  fs = require('fs');

  util = require('util');

  path = require('path');

  coffeeScript = require('coffee-script');

  _ = require('lodash');

  NodeWrapper = require('./NodeWrapper');

  ref = require('./utils/helpers'), mkdirs = ref.mkdirs, statFile = ref.statFile, excludeFile = ref.excludeFile;

  EXTENSIONS = require('./constants').EXTENSIONS;

  SkipVisitor = require('./SkipVisitor');

  exports.INSTRUMENTORS = INSTRUMENTORS = {
    jscoverage: require('./instrumentors/JSCoverage'),
    istanbul: require('./instrumentors/Istanbul')
  };

  CoverageError = (function(superClass) {
    extend(CoverageError, superClass);

    function CoverageError(message) {
      this.message = message;
      this.name = "CoverageError";
      Error.call(this);
      Error.captureStackTrace(this, arguments.callee);
    }

    return CoverageError;

  })(Error);

  factoryDefaults = {
    exclude: [],
    recursive: true,
    bare: false,
    instrumentor: 'jscoverage'
  };

  exports.getInstrumentorClass = getInstrumentorClass = function(instrumentorName) {
    var instrumentor;
    instrumentor = INSTRUMENTORS[instrumentorName];
    if (!instrumentor) {
      throw new Error("Invalid instrumentor " + instrumentorName + ". Valid options are: " + (Object.keys(INSTRUMENTORS).join(', ')));
    }
    return instrumentor;
  };

  exports.CoverageInstrumentor = (function(superClass) {
    var getEffectiveOptions, validateSrcDest, writeToFile;

    extend(CoverageInstrumentor, superClass);

    function CoverageInstrumentor(options) {
      if (options == null) {
        options = {};
      }
      this.defaultOptions = _.defaults({}, options, factoryDefaults);
      _.defaults(this.defaultOptions, getInstrumentorClass(this.defaultOptions.instrumentor).getDefaultOptions());
    }

    writeToFile = function(outFile, content) {
      return fs.writeFileSync(outFile, content);
    };

    validateSrcDest = function(source, out) {
      var outStat, sourceStat;
      sourceStat = statFile(source);
      outStat = out ? statFile(out) : null;
      if (!sourceStat) {
        throw new CoverageError("Source file " + source + " does not exist.");
      }
      if (outStat) {
        if (sourceStat.isFile() && outStat.isDirectory()) {
          throw new CoverageError("Refusing to overwrite directory " + out + " with file.");
        }
        if (sourceStat.isDirectory() && outStat.isFile()) {
          throw new CoverageError("Refusing to overwrite file " + out + " with directory.");
        }
      }
      return {
        sourceStat: sourceStat,
        outStat: outStat
      };
    };

    CoverageInstrumentor.prototype.instrument = function(source, out, options) {
      var sourceStat;
      if (options == null) {
        options = {};
      }
      sourceStat = validateSrcDest(source, out).sourceStat;
      if (sourceStat.isFile()) {
        return this.instrumentFile(source, out, options);
      } else if (sourceStat.isDirectory()) {
        return this.instrumentDirectory(source, out, options);
      } else {
        throw new CoverageError("Can't instrument " + source + ".");
      }
    };

    CoverageInstrumentor.prototype.getOutputFileName = function(fileName) {
      var coffee_extension, ext, outFile;
      if (fileName == null) {
        return null;
      }
      outFile = fileName;
      for (coffee_extension in EXTENSIONS) {
        ext = EXTENSIONS[coffee_extension];
        if (_.endsWith(fileName.toLowerCase(), coffee_extension)) {
          outFile = fileName.slice(0, +(-(coffee_extension.length + 1)) + 1 || 9e9) + ext.js_extension;
          break;
        }
      }
      return outFile;
    };

    getEffectiveOptions = function(options, defaultOptions) {
      if (options == null) {
        options = {};
      }
      return _.defaults({}, options, defaultOptions);
    };

    CoverageInstrumentor.prototype.instrumentDirectory = function(sourceDirectory, outDirectory, options) {
      var answer, coffee_extension, effectiveOptions, file, inst, j, len, outDirectoryStat, outFile, outputDirectoryExists, processed, ref1, ref2, ref3, sourceDirectoryMode, sourceDirectoryStat, sourceFile, sourceStat;
      if (options == null) {
        options = {};
      }
      sourceDirectory = path.resolve(sourceDirectory);
      sourceDirectoryStat = statFile(sourceDirectory);
      if (!sourceDirectoryStat) {
        return null;
      }
      this.emit("instrumentingDirectory", sourceDirectory, outDirectory);
      effectiveOptions = getEffectiveOptions(options, this.defaultOptions);
      effectiveOptions.basePath = effectiveOptions.basePath ? path.resolve(effectiveOptions.basePath) : sourceDirectory;
      answer = {
        lines: 0
      };
      validateSrcDest(sourceDirectory, outDirectory);
      if (!_.endsWith(sourceDirectory, path.sep)) {
        sourceDirectory += path.sep;
      }
      sourceDirectoryMode = sourceDirectoryStat.mode;
      if (outDirectory) {
        if (!_.endsWith(outDirectory, path.sep)) {
          outDirectory += path.sep;
        }
        outDirectoryStat = statFile(outDirectory);
        outputDirectoryExists = !!outDirectoryStat;
      }
      ref1 = fs.readdirSync(sourceDirectory);
      for (j = 0, len = ref1.length; j < len; j++) {
        file = ref1[j];
        sourceFile = sourceDirectory + file;
        if (excludeFile(sourceFile, effectiveOptions)) {
          this.emit("skip", sourceDirectory + file);
          continue;
        }
        sourceStat = statFile(sourceFile);
        if (!sourceStat) {
          continue;
        }
        outFile = outDirectory ? outDirectory + file : null;
        if (effectiveOptions.recursive && sourceStat.isDirectory()) {
          inst = this.instrumentDirectory(sourceFile, outFile, effectiveOptions);
          answer.lines += (ref2 = inst != null ? inst.lines : void 0) != null ? ref2 : 0;
        } else {
          processed = false;
          for (coffee_extension in EXTENSIONS) {
            if (coffee_extension === '._coffee') {
              continue;
            }
            if (_.endsWith(file.toLowerCase(), coffee_extension) && sourceStat.isFile()) {
              if ((outDirectory != null) && !outputDirectoryExists) {
                mkdirs(outDirectory, sourceDirectoryMode);
                outputDirectoryExists = true;
              }
              outFile = this.getOutputFileName(outFile);
              inst = this.instrumentFile(sourceFile, outFile, effectiveOptions);
              answer.lines += (ref3 = inst != null ? inst.lines : void 0) != null ? ref3 : 0;
              processed = true;
              break;
            }
          }
        }
      }
      return answer;
    };

    CoverageInstrumentor.prototype.instrumentFile = function(sourceFile, outFile, options) {
      var answer, data, effectiveOptions;
      if (outFile == null) {
        outFile = null;
      }
      if (options == null) {
        options = {};
      }
      this.emit("instrumentingFile", sourceFile, outFile);
      effectiveOptions = getEffectiveOptions(options, this.defaultOptions);
      validateSrcDest(sourceFile, outFile);
      data = fs.readFileSync(sourceFile, 'utf8');
      answer = this.instrumentCoffee(path.resolve(sourceFile), data, effectiveOptions);
      if (outFile) {
        writeToFile(outFile, answer.init + answer.js);
      }
      return answer;
    };

    CoverageInstrumentor.prototype.instrumentCoffee = function(fileName, source, options) {
      var effectiveOptions, instrumentor, instrumentorConstructor, ref1, ref2, result;
      if (options == null) {
        options = {};
      }
      effectiveOptions = getEffectiveOptions(options, this.defaultOptions);
      if ((ref1 = effectiveOptions.log) != null) {
        ref1.info("Instrumenting " + fileName);
      }
      instrumentorConstructor = getInstrumentorClass(effectiveOptions.instrumentor);
      instrumentor = new instrumentorConstructor(fileName, source, effectiveOptions);
      result = exports._runInstrumentor(instrumentor, fileName, source, effectiveOptions);
      if ((ref2 = effectiveOptions.initFileStream) != null) {
        ref2.write(result.init);
      }
      return result;
    };

    return CoverageInstrumentor;

  })(events.EventEmitter);

  exports._runInstrumentor = function(instrumentor, fileName, source, options) {
    var answer, ast, coffeeOptions, err, error, error1, init, js, ref1, ref2, runVisitor, token, tokens, wrappedAST;
    if (options == null) {
      options = {};
    }
    assert(instrumentor, "instrumentor");
    try {
      if ((ref1 = options.log) != null) {
        if (typeof ref1.debug === "function") {
          ref1.debug("Instrumenting " + fileName);
        }
      }
      coffeeOptions = {
        bare: (ref2 = options.bare) != null ? ref2 : false,
        literate: /\.(litcoffee|coffee\.md)$/.test(fileName)
      };
      tokens = coffeeScript.tokens(source, coffeeOptions);
      coffeeOptions.referencedVars = (function() {
        var j, len, results;
        results = [];
        for (j = 0, len = tokens.length; j < len; j++) {
          token = tokens[j];
          if (token.variable) {
            results.push(token[1]);
          }
        }
        return results;
      })();
      ast = coffeeScript.nodes(tokens);
    } catch (error) {
      err = error;
      throw new CoverageError("Could not parse " + fileName + ": " + err.stack);
    }
    runVisitor = (function(_this) {
      return function(visitor, nodeWrapper) {
        var i, indent, name, ref3, ref4;
        if ((ref3 = nodeWrapper.node.coffeeCoverage) != null ? ref3.generated : void 0) {
          return;
        }
        if (((ref4 = options.log) != null ? ref4.debug : void 0) != null) {
          indent = ((function() {
            var j, ref5, results;
            results = [];
            for (i = j = 0, ref5 = nodeWrapper.depth; 0 <= ref5 ? j < ref5 : j > ref5; i = 0 <= ref5 ? ++j : --j) {
              results.push("  ");
            }
            return results;
          })()).join('');
          options.log.debug(indent + "Examining " + (nodeWrapper.toString()));
        }
        if (nodeWrapper.isStatement) {
          if (typeof visitor["visitStatement"] === "function") {
            visitor["visitStatement"](nodeWrapper);
          }
        }
        if (typeof visitor[name = "visit" + nodeWrapper.type] === "function") {
          visitor[name](nodeWrapper);
        }
        return nodeWrapper.forEachChild(function(child) {
          return runVisitor(visitor, child);
        });
      };
    })(this);
    wrappedAST = new NodeWrapper(ast);
    runVisitor(new SkipVisitor(fileName), wrappedAST);
    runVisitor(instrumentor, wrappedAST);
    init = instrumentor.getInitString();
    try {
      js = ast.compile(coffeeOptions);
    } catch (error1) {
      err = error1;

      /* !pragma coverage-skip-block */
      throw new CoverageError("Could not compile " + fileName + " after instrumenting: " + err.stack);
    }
    answer = {
      init: init,
      js: js,
      lines: instrumentor.getInstrumentedLineCount()
    };
    return answer;
  };

}).call(this);
