// Generated by CoffeeScript 1.10.0
(function() {
  var NodeWrapper, PRAGMAS, PRAGMA_PREFIX, SkipVisitor, _;

  _ = require('lodash');

  NodeWrapper = require('./NodeWrapper');

  PRAGMA_PREFIX = '!pragma';

  PRAGMAS = [
    {
      regex: /^!pragma\s+coverage-skip-next$/,
      istanbulRegex: /^istanbul\s+ignore\s+next$/,
      fn: function(self, node, match, options) {
        var next;
        if (options == null) {
          options = {};
        }
        next = self._getNext(node, match);
        return next.markAll('skip', true);
      }
    }, {
      regex: /^!pragma\s+coverage-skip-block$/,
      fn: function(self, node, match, options) {
        var ifBody, ifNode, parent, ref;
        if (options == null) {
          options = {};
        }
        parent = node.parent;
        parent.markAll('skip', true);
        if (parent.type !== 'Block') {

          /* !pragma coverage-skip-block */
          throw new Error(("Pragma '" + match[0] + "' at " + (this._toLocString(node)) + " is not ") + "child of a Block (how did you even do this!?)");
        }
        if (((ref = parent.parent) != null ? ref.type : void 0) === 'If') {
          ifBody = parent;
          ifNode = parent.parent;
          if (ifBody.childName === 'body') {
            return ifNode.mark('skipIf', true);
          } else {
            return ifNode.mark('skipElse', true);
          }
        }
      }
    }, {
      regex: /^!pragma\s+no-coverage-next$/,
      fn: function(self, node, match, options) {
        var next;
        if (options == null) {
          options = {};
        }
        next = self._getNext(node, match);
        return next.markAll('noCoverage', true);
      }
    }, {
      istanbulRegex: /^istanbul\s+ignore\s+if$/,
      fn: function(self, node, match, options) {
        var ifNode, ref;
        if (options == null) {
          options = {};
        }
        ifNode = self._getNext(node, match, 'If');
        ifNode.mark('skipIf', true);
        return (ref = ifNode.child('body')) != null ? ref.markAll('skip', true) : void 0;
      }
    }, {
      istanbulRegex: /^istanbul\s+ignore\s+else$/,
      fn: function(self, node, match, options) {
        var ifNode, ref;
        if (options == null) {
          options = {};
        }
        ifNode = self._getNext(node, match, 'If');
        ifNode.mark('skipElse', true);
        return (ref = ifNode.child('elseBody')) != null ? ref.markAll('skip', true) : void 0;
      }
    }
  ];

  module.exports = SkipVisitor = (function() {
    function SkipVisitor(fileName) {
      this.fileName = fileName;
    }

    SkipVisitor.prototype.visitComment = function(node) {
      var comment, found, ref, ref1;
      comment = (ref = (ref1 = node.node.comment) != null ? ref1.trim().toLowerCase() : void 0) != null ? ref : '';
      found = false;
      if (_.startsWith(comment, PRAGMA_PREFIX)) {
        return PRAGMAS.filter(function(pragma) {
          return pragma.regex != null;
        }).forEach((function(_this) {
          return function(pragma) {
            var match;
            if (match = comment.match(pragma.regex)) {
              return pragma.fn(_this, node, match, _this.options);
            }
          };
        })(this));
      } else if (_.startsWith(comment, 'istanbul')) {
        return PRAGMAS.filter(function(pragma) {
          return pragma.istanbulRegex != null;
        }).forEach((function(_this) {
          return function(pragma) {
            var match;
            if (match = comment.match(pragma.istanbulRegex)) {
              return pragma.fn(_this, node, match, _this.options);
            }
          };
        })(this));
      }
    };

    SkipVisitor.prototype._toLocString = function(node) {
      return this.fileName + " (" + (node.locationData.first_line + 1) + ":" + (node.locationData.first_column + 1) + ")";
    };

    SkipVisitor.prototype._getNext = function(node, match, type) {
      var next;
      if (type == null) {
        type = null;
      }
      next = node.next();
      while ((next != null ? next.type : void 0) === 'Comment') {
        next = next.next();
      }
      if (next == null) {
        throw new Error("Pragma '" + match[0] + "' at " + (this._toLocString(node)) + " has no next statement");
      }
      if ((type != null) && next.type !== type) {
        throw new Error("Statement after pragma '" + match[0] + "' at " + (this._toLocString(node)) + " is not of type " + type);
      }
      return next;
    };

    return SkipVisitor;

  })();

}).call(this);
