// Generated by CoffeeScript 1.10.0
(function() {
  var NodeWrapper, _, assert, coffeeScript, compile, forNodeAndChildren;

  assert = require('assert');

  coffeeScript = require('coffee-script');

  _ = require('lodash');

  module.exports = NodeWrapper = (function() {
    function NodeWrapper(node1, parent, childName1, childIndex1, depth) {
      var ref, ref1;
      this.node = node1;
      this.parent = parent;
      this.childName = childName1;
      this.childIndex = childIndex1;
      this.depth = depth != null ? depth : 0;
      assert(this.node);
      this.locationData = this.node.locationData;
      this.type = ((ref = this.node.constructor) != null ? ref.name : void 0) || null;
      this.isStatement = (this.parent != null) && this.type !== 'Comment' && this.parent.type === 'Block' && this.childName === 'expressions';
      if (this.isStatement && this.type === 'Value' && ((ref1 = this.parent.parent) != null ? ref1.type : void 0) === 'Class') {
        this.isStatement = false;
      }
    }

    NodeWrapper.prototype.forEachChild = function(fn) {
      if (this.node.children != null) {
        return this.node.children.forEach((function(_this) {
          return function(childName) {
            return _this.forEachChildOfType(childName, fn);
          };
        })(this));
      }
    };

    NodeWrapper.prototype.forEachChildOfType = function(childName, fn) {
      var child, childNodes, children, index, results, wrappedChild;
      children = this.node[childName];
      if (children != null) {
        childNodes = _.flatten([children], true);
        index = 0;
        results = [];
        while (index < childNodes.length) {
          child = childNodes[index];
          if (child.constructor.name != null) {
            wrappedChild = new NodeWrapper(child, this, childName, index, this.depth + 1);
            fn(wrappedChild);
          }
          results.push(index++);
        }
        return results;
      }
    };

    NodeWrapper.prototype.markAll = function(varName, value) {
      var markCoffeeNode;
      if (value == null) {
        value = true;
      }
      markCoffeeNode = function(coffeeNode) {
        if (coffeeNode.coffeeCoverage == null) {
          coffeeNode.coffeeCoverage = {};
        }
        coffeeNode.coffeeCoverage[varName] = value;
        return coffeeNode.eachChild(markCoffeeNode);
      };
      return markCoffeeNode(this.node);
    };

    NodeWrapper.prototype.mark = function(varName, value) {
      var base;
      if (value == null) {
        value = true;
      }
      if ((base = this.node).coffeeCoverage == null) {
        base.coffeeCoverage = {};
      }
      return this.node.coffeeCoverage[varName] = value;
    };

    NodeWrapper.prototype.isMarked = function(varName, value) {
      var ref;
      if (value == null) {
        value = true;
      }
      return ((ref = this.node.coffeeCoverage) != null ? ref[varName] : void 0) === value;
    };

    NodeWrapper.prototype.child = function(name, index) {
      var child;
      if (index == null) {
        index = null;
      }
      child = this.node[name];
      if (!child) {
        return null;
      }
      if (index == null) {
        assert(!_.isArray(child));
        return new NodeWrapper(child, this, name, 0, this.depth + 1);
      } else {
        assert(_.isArray(child));
        if (!child[index]) {
          return null;
        }
        return new NodeWrapper(child[index], this, name, index, this.depth + 1);
      }
    };

    NodeWrapper.prototype._fixChildIndex = function() {
      var childIndex;
      if (!_.isArray(this.parent.node[this.childName])) {
        return this.childIndex = 0;
      } else {
        if (this.parent.node[this.childName][this.childIndex] !== this.node) {
          childIndex = _.indexOf(this.parent.node[this.childName], this.node);
          if (childIndex === -1) {
            throw new Error("Can't find node in parent");
          }
          return this.childIndex = childIndex;
        }
      }
    };

    NodeWrapper.prototype.next = function() {
      var nextNode, ref;
      if ((ref = this.parent.type) !== 'Block' && ref !== 'Obj') {
        return null;
      }
      this._fixChildIndex();
      nextNode = this.parent.node[this.childName][this.childIndex + 1];
      if (nextNode == null) {
        return null;
      } else {
        return new NodeWrapper(nextNode, this.parent, this.childName, this.childIndex + 1, this.depth);
      }
    };

    NodeWrapper.prototype._insertBeforeIndex = function(childName, index, csSource) {
      var compiled;
      assert(_.isArray(this.node[childName]), (this.toString()) + " -> " + childName);
      compiled = compile(csSource, this.node);
      return this.node[childName].splice(index, 0, compiled);
    };

    NodeWrapper.prototype.insertBefore = function(csSource) {
      this._fixChildIndex();
      return this.parent._insertBeforeIndex(this.childName, this.childIndex, csSource);
    };

    NodeWrapper.prototype.insertAfter = function(csSource) {
      this._fixChildIndex();
      return this.parent._insertBeforeIndex(this.childName, this.childIndex + 1, csSource);
    };

    NodeWrapper.prototype.insertAtStart = function(childName, csSource) {
      var child, ref;
      child = this.node[childName];
      if (this.type === 'Block' && childName === 'expressions') {
        if (!child) {
          return this.node[childName] = [compile(csSource, this.node)];
        } else {
          return this.node[childName].unshift(compile(csSource, this.node));
        }
      } else if ((child != null ? (ref = child.constructor) != null ? ref.name : void 0 : void 0) === 'Block') {
        return child.expressions.unshift(compile(csSource, child));
      } else if (!child) {
        return this.node[childName] = compile(csSource, this.node);
      } else {
        throw new Error("Don't know how to insert statement into " + this.type + "." + childName + ": " + this.type[childName]);
      }
    };

    NodeWrapper.prototype.toString = function() {
      var answer, ref;
      answer = '';
      if (this.childName) {
        answer += this.childName + "[" + this.childIndex + "]:";
      }
      answer += this.type;
      if (this.node.locationData != null) {
        return answer += " (" + (((ref = this.node.locationData) != null ? ref.first_line : void 0) + 1) + ":" + (this.node.locationData.first_column + 1) + ")";
      }
    };

    return NodeWrapper;

  })();

  forNodeAndChildren = function(node, fn) {
    fn(node);
    return node.eachChild(fn);
  };

  compile = function(csSource, node) {
    var compiled, line;
    compiled = coffeeScript.nodes(csSource);
    line = node.locationData.first_line;
    forNodeAndChildren(compiled, function(n) {
      n.locationData = {
        first_line: line - 1,
        first_column: 0,
        last_line: line - 1,
        last_column: 0
      };
      if (n.coffeeCoverage == null) {
        n.coffeeCoverage = {};
      }
      return n.coffeeCoverage.generated = true;
    });
    return compiled;
  };

}).call(this);
