// Generated by CoffeeScript 1.10.0
(function() {
  var CompiledCache, EXTENSIONS, _, fs, getRelativeFilename, mkdirs, path, ref;

  fs = require('fs');

  path = require('path');

  _ = require('lodash');

  EXTENSIONS = require('./constants').EXTENSIONS;

  ref = require('./utils/helpers'), mkdirs = ref.mkdirs, getRelativeFilename = ref.getRelativeFilename;

  module.exports = CompiledCache = (function() {
    function CompiledCache(basePath, cacheDir1, ext) {
      this.basePath = basePath;
      this.cacheDir = cacheDir1;
      this.ext = ext != null ? ext : '_covered';
    }

    CompiledCache.prototype._getCacheFileName = function(fileName, options) {
      var cacheFile, newExt, ref1, relativeFile;
      if (options == null) {
        options = {};
      }
      newExt = (ref1 = options.ext) != null ? ref1 : this.ext;
      relativeFile = getRelativeFilename(this.basePath, fileName);
      cacheFile = path.resolve(this.cacheDir, relativeFile);
      cacheFile += newExt;
      return cacheFile;
    };

    CompiledCache.prototype.get = function(fileName, compileFn) {
      var answer, cacheFileName, cacheStat, fileStat;
      if (compileFn == null) {
        compileFn = null;
      }
      if (!this.cacheDir) {
        return typeof compileFn === "function" ? compileFn() : void 0;
      }
      cacheFileName = this._getCacheFileName(fileName);
      answer = null;
      if (fs.existsSync(cacheFileName)) {
        fileStat = fs.statSync(fileName);
        cacheStat = fs.statSync(cacheFileName);
        if (cacheStat.ctime > fileStat.mtime) {
          answer = fs.readFileSync(cacheFileName, {
            encoding: 'utf8'
          });
        }
      }
      if ((answer == null) && (compileFn != null)) {
        answer = compileFn();
        this.put(fileName, answer);
      }
      return answer;
    };

    CompiledCache.prototype.put = function(fileName, contents, options) {
      var cacheDir, cacheFileName;
      if (options == null) {
        options = {};
      }
      if (!this.cacheDir || !contents) {
        return;
      }
      cacheFileName = this._getCacheFileName(fileName, options);
      cacheDir = path.dirname(cacheFileName);
      mkdirs(cacheDir);
      return fs.writeFileSync(cacheFileName, contents, {
        encoding: 'utf8'
      });
    };

    return CompiledCache;

  })();

}).call(this);
