"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_camelcase_1 = __importDefault(require("lodash.camelcase"));
var ramda_1 = require("ramda");
var lodash_reduce_1 = __importDefault(require("lodash.reduce"));
exports.semverToString = function (s) {
    return s.major + "." + s.minor + "." + s.patch;
};
exports.normalizeName = function (s) { return lodash_camelcase_1.default(s); };
exports.normalizeRequiredProperties = function (schema) {
    if (schema.required === true) {
        if (schema.properties) {
            var reducer = function (memo, obj, key) {
                if (obj.required !== false) {
                    memo.push(key);
                }
                return memo;
            };
            schema.required = lodash_reduce_1.default(schema.properties, reducer, []);
        }
        else {
            schema.required = [];
        }
    }
    return schema;
};
exports.versionSchemas = function () {
    var schemas = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        schemas[_i] = arguments[_i];
    }
    if (!schemas.length) {
        throw new Error('expected list of schemas');
    }
    var titles = ramda_1.map(ramda_1.path(['schema', 'title']))(schemas);
    var unique = ramda_1.uniq(titles);
    if (unique.length !== 1) {
        throw new Error("expected same schema titles, got " + titles.join(', '));
    }
    var result = {};
    schemas.forEach(function (s) {
        exports.normalizeRequiredProperties(s.schema);
        var version = exports.semverToString(s.version);
        result[version] = s;
    });
    return result;
};
exports.setPackageName = function (schemas, packageName) {
    Object.keys(schemas).forEach(function (name) {
        Object.keys(schemas[name]).forEach(function (version) {
            var schema = schemas[name][version];
            if (!schema.package) {
                schema.package = packageName;
            }
        });
    });
    return schemas;
};
exports.combineSchemas = function () {
    var versioned = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        versioned[_i] = arguments[_i];
    }
    var result = {};
    versioned.forEach(function (v) {
        var title = v[Object.keys(v)[0]].schema.title;
        var name = exports.normalizeName(title);
        result[name] = v;
    });
    return result;
};
