"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ramda_1 = require("ramda");
var api_1 = require("./api");
var sanitize_1 = require("./sanitize");
var reduceToSchema = ramda_1.curry(function (schema, object) {
    schema = schema.properties || (schema.schema || schema.items).properties;
    var objectProps = ramda_1.keys(object);
    var schemaProps = ramda_1.keys(schema);
    return ramda_1.reduce(function (trimmedObj, prop) {
        if (ramda_1.contains(prop, schemaProps)) {
            if (object[prop] && sanitize_1.isJsonSchema(schema[prop])) {
                trimmedObj[prop] = reduceToSchema(schema[prop], object[prop]);
            }
            else if (object[prop] && sanitize_1.hasPropertiesArray(schema[prop])) {
                trimmedObj[prop] = ramda_1.map(reduceToSchema(schema[prop]), object[prop]);
            }
            else {
                trimmedObj[prop] = object[prop];
            }
        }
        return trimmedObj;
    }, {}, objectProps);
});
var trimObject = function (schemas, schemaName, version, object) {
    var schema = api_1.getObjectSchema(schemas, schemaName, version);
    if (!schema) {
        throw new Error("Could not schema " + schemaName + "@" + version);
    }
    if (!object) {
        throw new Error('Expected an object to trim');
    }
    return reduceToSchema(schema, object);
};
exports.trim = ramda_1.curry(trimObject);
