"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.detectors = function (formats) {
    var result = {};
    Object.keys(formats).forEach(function (name) {
        result[name] = formats[name].detect;
    });
    return result;
};
exports.regexAsPatternKey = function (r) {
    var s = r.toString();
    var middle = s.substr(1, s.length - 2);
    return middle;
};
exports.getDefaults = function (formats) {
    var result = {};
    Object.keys(formats).forEach(function (key) {
        var format = formats[key];
        if (typeof format.defaultValue !== 'undefined') {
            result[format.name] = format.defaultValue;
        }
    });
    return result;
};
