"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var json2md_1 = __importDefault(require("json2md"));
var ramda_1 = require("ramda");
var __1 = require("..");
var doc_formats_1 = require("./doc-formats");
var utils_1 = require("./utils");
var title = [{ h1: 'Schemas' }];
var titleLink = [{ p: '[🔝](#schemas)' }];
function documentSchemas(schemas, formats) {
    var toDoc = function (schemaName) {
        var versions = __1.getSchemaVersions(schemas)(schemaName);
        if (!versions.length) {
            return [{ h2: "\u26A0\uFE0F Could not find any versions of schema " + schemaName }];
        }
        var documentSchemaVersion = function (version) {
            var schema = __1.getObjectSchema(schemas)(schemaName)(version);
            if (!schema) {
                throw new Error("cannot find schema " + schemaName + "@" + version);
            }
            var schemaDoc = utils_1.documentObjectSchema(schema, schemas, formats);
            return ramda_1.flatten(schemaDoc.concat(titleLink));
        };
        var versionFragments = versions.map(documentSchemaVersion);
        var start = [{ h2: __1.normalizeName(schemaName) }];
        return start.concat(ramda_1.flatten(versionFragments));
    };
    var fragments = ramda_1.flatten(__1.schemaNames(schemas).map(toDoc));
    var schemaNameToTopLevelLink = function (schemaName) {
        return "[" + schemaName + "](#" + utils_1.anchor(schemaName) + ")";
    };
    var schemaVersionLink = function (schemaName) { return function (version) {
        return "[" + version + "](#" + utils_1.anchor(schemaName + version) + ")";
    }; };
    var tocHeading = function (schemaName) {
        var versions = __1.getSchemaVersions(schemas)(schemaName);
        var topLink = schemaNameToTopLevelLink(schemaName);
        if (versions.length < 2) {
            return topLink;
        }
        else {
            var versionLinks = versions.map(schemaVersionLink(schemaName));
            var linkWithVersions = topLink + ' - ' + versionLinks.join(', ');
            return linkWithVersions;
        }
    };
    var headings = __1.schemaNames(schemas);
    var toc = [
        {
            ul: headings.map(tocHeading),
        },
    ];
    var list = title.concat(toc).concat(fragments);
    if (formats) {
        list = list.concat(doc_formats_1.documentCustomFormats(formats)).concat(titleLink);
    }
    return json2md_1.default(list);
}
exports.documentSchemas = documentSchemas;
