"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var is_my_json_valid_1 = __importDefault(require("@bahmutov/is-my-json-valid"));
var debug_1 = __importDefault(require("debug"));
var json_stable_stringify_1 = __importDefault(require("json-stable-stringify"));
var lodash_get_1 = __importDefault(require("lodash.get"));
var lodash_set_1 = __importDefault(require("lodash.set"));
var ramda_1 = require("ramda");
var formats_1 = require("./formats");
var sanitize_1 = require("./sanitize");
var trim_1 = require("./trim");
var utils = __importStar(require("./utils"));
var debug = debug_1.default('schema-tools');
exports.getVersionedSchema = function (schemas) { return function (name) {
    name = utils.normalizeName(name);
    return schemas[name];
}; };
var _getObjectSchema = function (schemas, schemaName, version) {
    schemaName = utils.normalizeName(schemaName);
    var namedSchemas = schemas[schemaName];
    if (!namedSchemas) {
        debug('missing schema %s', schemaName);
        return;
    }
    return namedSchemas[version];
};
exports.getObjectSchema = ramda_1.curry(_getObjectSchema);
var _hasSchema = function (schemas, schemaName, version) { return Boolean(_getObjectSchema(schemas, schemaName, version)); };
exports.hasSchema = ramda_1.curry(_hasSchema);
exports.schemaNames = function (schemas) {
    return Object.keys(schemas).sort();
};
exports.getSchemaVersions = function (schemas) { return function (schemaName) {
    schemaName = utils.normalizeName(schemaName);
    if (schemas[schemaName]) {
        return Object.keys(schemas[schemaName]);
    }
    return [];
}; };
exports.getExample = ramda_1.curry(function (schemas, schemaName, version) {
    var o = exports.getObjectSchema(schemas)(schemaName)(version);
    if (!o) {
        debug('could not find object schema %s@%s', schemaName, version);
        return;
    }
    return o.example;
});
var dataHasAdditionalPropertiesValidationError = {
    field: 'data',
    message: 'has additional properties',
};
var findDataHasAdditionalProperties = ramda_1.find(ramda_1.whereEq(dataHasAdditionalPropertiesValidationError));
var includesDataHasAdditionalPropertiesError = function (errors) { return findDataHasAdditionalProperties(errors) !== undefined; };
var errorToString = function (error) {
    return error.field + " " + error.message;
};
var errorsToStrings = function (errors) {
    return errors.map(errorToString);
};
exports.validateBySchema = function (schema, formats, greedy) {
    if (greedy === void 0) { greedy = true; }
    return function (object) {
        var validate = is_my_json_valid_1.default(schema, { formats: formats, greedy: greedy });
        if (validate(object)) {
            return true;
        }
        var uniqueErrors = ramda_1.uniqBy(errorToString, validate.errors);
        if (includesDataHasAdditionalPropertiesError(uniqueErrors) &&
            ramda_1.keys(schema.properties).length) {
            var hasData = findDataHasAdditionalProperties(uniqueErrors);
            var additionalProperties = ramda_1.difference(ramda_1.keys(object), ramda_1.keys(schema.properties));
            hasData.message += ': ' + additionalProperties.join(', ');
        }
        var errors = ramda_1.uniq(errorsToStrings(uniqueErrors));
        return errors;
    };
};
exports.validate = function (schemas, formats, greedy) {
    if (greedy === void 0) { greedy = true; }
    return function (schemaName, version) { return function (object) {
        schemaName = utils.normalizeName(schemaName);
        var namedSchemas = schemas[schemaName];
        if (!namedSchemas) {
            return ["Missing schema " + schemaName];
        }
        var aSchema = namedSchemas[version];
        if (!aSchema) {
            return ["Missing schema " + schemaName + "@" + version];
        }
        return exports.validateBySchema(aSchema.schema, formats, greedy)(object);
    }; };
};
var SchemaError = (function (_super) {
    __extends(SchemaError, _super);
    function SchemaError(message, errors, object, example, schemaName, schemaVersion) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, message) || this;
        Object.setPrototypeOf(_this, _newTarget.prototype);
        _this.errors = errors;
        _this.object = object;
        _this.example = example;
        _this.schemaName = schemaName;
        if (schemaVersion) {
            _this.schemaVersion = schemaVersion;
        }
        return _this;
    }
    return SchemaError;
}(Error));
exports.SchemaError = SchemaError;
var AssertBySchemaDefaults = {
    greedy: true,
    substitutions: [],
    omit: {
        errors: false,
        object: false,
        example: false,
    },
};
exports.assertBySchema = function (schema, example, options, label, formats, schemaVersion) {
    if (example === void 0) { example = {}; }
    return function (object) {
        var allOptions = ramda_1.mergeDeepLeft(options || AssertBySchemaDefaults, AssertBySchemaDefaults);
        var replace = function () {
            var cloned = ramda_1.clone(object);
            allOptions.substitutions.forEach(function (property) {
                var value = lodash_get_1.default(example, property);
                lodash_set_1.default(cloned, property, value);
            });
            return cloned;
        };
        var replaced = allOptions.substitutions.length ? replace() : object;
        var result = exports.validateBySchema(schema, formats, allOptions.greedy)(replaced);
        if (result === true) {
            return object;
        }
        var title = label ? "Schema " + label + " violated" : 'Schema violated';
        var emptyLine = '';
        var parts = [title];
        if (!allOptions.omit.errors) {
            parts = parts.concat([emptyLine, 'Errors:']).concat(result);
        }
        if (!allOptions.omit.object) {
            var objectString = json_stable_stringify_1.default(replaced, { space: '  ' });
            parts = parts.concat([emptyLine, 'Current object:', objectString]);
        }
        if (!allOptions.omit.example) {
            var exampleString = json_stable_stringify_1.default(example, { space: '  ' });
            parts = parts.concat([
                emptyLine,
                'Expected object like this:',
                exampleString,
            ]);
        }
        var message = parts.join('\n');
        throw new SchemaError(message, result, replaced, example, schema.title, schemaVersion);
    };
};
exports.assertSchema = function (schemas, formats) { return function (name, version, options) { return function (object) {
    var example = exports.getExample(schemas)(name)(version);
    var schema = exports.getObjectSchema(schemas)(name)(version);
    if (!schema) {
        throw new Error("Could not find schema " + name + "@" + version);
    }
    var label = name + "@" + version;
    return exports.assertBySchema(schema.schema, example, options, label, formats, utils.semverToString(schema.version))(object);
}; }; };
var mergeSchemas = function (schemas) {
    return ramda_1.mergeAll(schemas);
};
var mergeFormats = function (formats) {
    return ramda_1.mergeAll(formats);
};
var exists = function (x) { return Boolean(x); };
exports.bind = function () {
    var options = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        options[_i] = arguments[_i];
    }
    var allSchemas = ramda_1.map(ramda_1.prop('schemas'), options);
    var schemas = mergeSchemas(allSchemas);
    var allFormats = ramda_1.filter(exists, ramda_1.map(ramda_1.prop('formats'), options));
    var formats = mergeFormats(allFormats);
    var formatDetectors = formats_1.detectors(formats);
    var defaults = formats_1.getDefaults(formats);
    var api = {
        assertSchema: exports.assertSchema(schemas, formatDetectors),
        schemaNames: exports.schemaNames(schemas),
        getExample: exports.getExample(schemas),
        sanitize: sanitize_1.sanitize(schemas, defaults),
        validate: exports.validate(schemas),
        trim: trim_1.trim(schemas),
        hasSchema: exports.hasSchema(schemas),
    };
    return api;
};
