"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.video100Example = {
    duration: 620831,
    id: '63d4b234-ea19-4b9c-8852-dcd99bd5af21',
    instanceId: 'e5c580b2-3c30-42b0-8689-63f41a314536',
    url: 'https://storage.googleapis.com/foo/bar/039efe11-3a4f-4b80-a98d-def6a11b3cc4/screencasts/ci.mp4',
};
exports.Video100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'Video',
        description: 'Single test video',
        type: 'object',
        properties: {
            duration: {
                type: 'integer',
                minimum: 0,
                description: 'Video duration, milliseconds',
            },
            id: {
                type: 'string',
                format: 'uuid',
                description: 'UUID of the video record',
            },
            instanceId: {
                type: 'string',
                format: 'uuid',
            },
            url: {
                type: 'string',
                format: 'uri',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.video100Example,
};
exports.Video = schema_tools_1.versionSchemas(exports.Video100);
