"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.testExample100 = {
    id: '2e4b3a3a-a20d-4504-ab55-c825f3852dc1',
    testId: 'r4',
    instanceId: 'ee66da73-c0ae-4eeb-8147-732e797a790d',
    title: ['simple failing hook spec', 'beforeEach hooks', 'never gets here'],
    state: 'failed',
    body: 'function () {}',
    stack: "Error: fail1\n\nBecause this error occurred during a 'before each' hook we are skipping the remaining tests in the current suite: 'beforeEach hooks'\n    at stack trace line",
    error: "fail1\n\nBecause this error occurred during a 'before each' hook we are skipping the remaining tests in the current suite: 'beforeEach hooks'",
    timings: {
        lifecycle: 100,
        'before each': [
            {
                hookId: 'h1',
                fnDuration: 400,
                afterFnDuration: 200,
            },
        ],
    },
    failedFromHookId: 'h1',
    wallClockStartedAt: '2018-02-01T20:14:19.323Z',
    wallClockDuration: 1234,
    videoTimestamp: 9999,
};
exports.Test100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'Test',
        description: 'Test run information returned by the API',
        type: 'object',
        properties: {
            id: {
                type: 'string',
                format: 'uuid',
                description: 'Unique GUID of the test instance',
            },
            testId: {
                type: 'string',
                format: 'testId',
                description: 'Internal short test id set by the test runner',
            },
            instanceId: {
                type: 'string',
                format: 'uuid',
                description: 'GUID of the instance for the test',
            },
            title: {
                type: 'array',
                items: {
                    type: 'string',
                },
            },
            state: {
                type: 'string',
                format: 'testState',
                description: 'needs description!',
            },
            body: {
                type: 'string',
            },
            stack: {
                type: ['string', 'null'],
            },
            error: {
                type: ['string', 'null'],
            },
            timings: {
                type: 'object',
                properties: {
                    lifecycle: {
                        type: 'integer',
                        minimum: 0,
                        description: 'ms',
                    },
                    'before each': {
                        type: 'array',
                        items: {
                            type: 'object',
                        },
                    },
                },
            },
            failedFromHookId: {
                type: ['string', 'null'],
            },
            wallClockStartedAt: {
                type: ['string', 'null'],
                format: 'date-time',
            },
            wallClockDuration: {
                type: ['integer', 'null'],
                minimum: 0,
            },
            videoTimestamp: {
                type: ['integer', 'null'],
            },
        },
        required: ['id', 'instanceId', 'state', 'title'],
        additionalProperties: false,
    },
    example: exports.testExample100,
};
exports.Test = schema_tools_1.versionSchemas(exports.Test100);
