"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var formats_1 = require("../formats");
exports.testRunnerTestExample100 = {
    testId: 'r4',
    title: ['simple failing hook spec', 'beforeEach hooks', 'never gets here'],
    state: 'failed',
    body: 'function () {}',
    stack: "Error: fail1\n\nBecause this error occurred during a 'before each' hook we are skipping the remaining tests in the current suite: 'beforeEach hooks'\n    at stack trace line",
    error: "fail1\n\nBecause this error occurred during a 'before each' hook we are skipping the remaining tests in the current suite: 'beforeEach hooks'",
    timings: {
        lifecycle: 100,
        'before each': [
            {
                hookId: 'h1',
                fnDuration: 400,
                afterFnDuration: 200,
            },
        ],
    },
    failedFromHookId: 'h1',
    wallClockStartedAt: '2018-02-01T20:14:19.323Z',
    wallClockDuration: 1234,
    videoTimestamp: 9999,
};
exports.TestRunnerTest100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.test',
        description: 'Test information uploaded by the test runner',
        type: 'object',
        properties: {
            testId: {
                type: 'string',
                format: formats_1.formats.testId.name,
                description: 'Internal short test id set by the test runner',
            },
            title: {
                type: 'array',
                items: {
                    type: 'string',
                },
            },
            state: {
                type: 'string',
                format: formats_1.formats.testState.name,
            },
            body: {
                type: ['string', 'null'],
                description: 'Source code of the test',
            },
            stack: {
                type: ['string', 'null'],
                description: 'Error stack as a string',
            },
            error: {
                type: ['string', 'null'],
                description: 'If there was an error, its message',
            },
            timings: {
                type: ['object', 'null'],
                description: 'Collected timings',
                properties: {
                    lifecycle: {
                        type: 'integer',
                        minimum: 0,
                        description: 'ms',
                    },
                    'before each': {
                        type: 'array',
                        items: {
                            type: 'object',
                        },
                    },
                },
            },
            failedFromHookId: {
                type: ['string', 'null'],
                format: formats_1.formats.hookId.name,
            },
            wallClockStartedAt: {
                type: ['string', 'null'],
                format: 'date-time',
            },
            wallClockDuration: {
                type: ['integer', 'null'],
                minimum: 0,
            },
            videoTimestamp: {
                type: ['integer', 'null'],
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.testRunnerTestExample100,
};
exports.TestRunnerTest = schema_tools_1.versionSchemas(exports.TestRunnerTest100);
