"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var formats_1 = require("../formats");
exports.testRunnerScreenshotExample100 = {
    clientId: '23942340234-cgdfgdfg-4565656',
    height: 1904,
    testId: 'sdklfjsdf-234234sdf-sdf-3r23rvd',
    testTitle: 'A Suite /// Test Title /// first screenshot',
    title: 'Project List displays all projects.png',
    width: 3358,
};
exports.TestRunnerScreenshot100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.screenshot',
        description: 'Image taken during the test and uploaded by the test runner',
        type: 'object',
        properties: {
            clientId: {
                type: 'string',
                description: 'Internal screenshot id',
            },
            height: {
                type: 'integer',
                minimum: 0,
                description: 'image height in pixels',
            },
            testId: {
                type: ['string', 'null'],
                description: 'Test id assigned by the test runner, if any',
            },
            testTitle: {
                type: 'string',
                description: 'Title of the test when the screenshot was taken',
            },
            title: {
                type: ['string', 'null'],
                description: 'Name of the file if the command used one',
            },
            width: {
                type: 'integer',
                minimum: 0,
                description: 'image width in pixels',
            },
        },
        required: ['clientId', 'height', 'testTitle', 'width'],
        additionalProperties: false,
    },
    example: exports.testRunnerScreenshotExample100,
};
exports.testRunnerScreenshotExample200 = {
    screenshotId: 'abc123',
    testId: 'r4',
    name: 'some screenshot name',
    height: 720,
    width: 1280,
    takenAt: '2016-05-13T02:37:15.748Z',
};
exports.TestRunnerScreenshot200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.screenshot',
        description: 'Image taken during the test and uploaded by the test runner',
        type: 'object',
        properties: {
            screenshotId: {
                type: 'string',
                description: 'Internal screenshot id assigned by the test runner',
            },
            testId: {
                type: 'string',
                format: formats_1.formats.testId.name,
                description: 'Internal test id assigned by the test runner',
            },
            height: {
                type: 'integer',
                minimum: 0,
                description: 'image height in pixels',
            },
            width: {
                type: 'integer',
                minimum: 0,
                description: 'image width in pixels',
            },
            takenAt: {
                type: 'string',
                format: 'date-time',
                description: 'Local timestamp to keep the screenshots sorted',
            },
            name: {
                type: ['string', 'null'],
                description: 'Name of the screenshot',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.testRunnerScreenshotExample200,
};
exports.TestRunnerScreenshot = schema_tools_1.versionSchemas(exports.TestRunnerScreenshot100, exports.TestRunnerScreenshot200);
