"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.testRunnerPlatformExample100 = {
    osName: 'linux',
    osVersion: '14.04',
    browserName: 'Electron',
    browserVersion: '53.0.2785.143',
    osMemory: {
        free: 10000,
        total: 20000,
    },
    osCpus: [
        {
            model: 'Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz',
            speed: 2800,
            times: {
                user: 300415800,
                nice: 200800,
                sys: 94852500,
                idle: 649447000,
                irq: 0,
            },
        },
    ],
};
exports.TestRunnerPlatform100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.platform',
        type: 'object',
        description: 'Browser and OS information sent by the test runner',
        properties: {
            osName: {
                type: 'string',
                enum: ['linux', 'darwin', 'win32'],
                description: 'Operating system name, for example "win32"',
            },
            osVersion: {
                type: 'string',
                description: 'Operating system version',
            },
            browserName: {
                type: 'string',
                description: 'Browser name, for example Chrome',
            },
            browserVersion: {
                type: 'string',
                description: 'Browser version, for example 65.0.2785.143',
            },
            osMemory: {
                type: ['object', 'null'],
                properties: {
                    free: {
                        type: 'integer',
                        minimum: 0,
                        required: true,
                    },
                    total: {
                        type: 'integer',
                        minimum: 0,
                        required: true,
                    },
                },
            },
            osCpus: {
                type: 'array',
                description: 'Information for every detected CPU core',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.testRunnerPlatformExample100,
};
exports.TestRunnerPlatform = schema_tools_1.versionSchemas(exports.TestRunnerPlatform100);
