"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.TestRunnerMochaReporterStats100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.mochaReporterStats',
        type: 'object',
        description: 'Stats from Mocha reporter - really dynamic and depends on the reporter',
        properties: {
            suites: {
                type: 'integer',
                minimum: 0,
            },
            tests: {
                type: 'integer',
                minimum: 0,
            },
            passes: {
                type: 'integer',
                minimum: 0,
            },
            pending: {
                type: 'integer',
                minimum: 0,
            },
            failures: {
                type: 'integer',
                minimum: 0,
            },
            start: {
                type: 'string',
            },
            end: {
                type: 'string',
            },
            duration: {
                type: 'integer',
                minimum: 0,
                description: 'ms',
            },
        },
        required: [],
        additionalProperties: true,
    },
    example: {
        suites: 5,
        tests: 6,
        passes: 1,
        pending: 1,
        failures: 3,
        start: '2018-02-01T20:14:19.323Z',
        end: '2018-02-01T20:14:19.323Z',
        duration: 1234,
    },
};
exports.TestRunnerMochaReporterStats = schema_tools_1.versionSchemas(exports.TestRunnerMochaReporterStats100);
