"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.testRunnerHookExample100 = {
    hookId: 'h1',
    hookName: 'before each',
    title: ['"before each" hook'],
    body: 'function () {\n      throw new Error("fail1");\n    }',
};
exports.TestRunnerHook100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.hook',
        description: 'Hook function running before or after test',
        type: 'object',
        properties: {
            hookId: {
                type: 'string',
                format: 'hookId',
            },
            hookName: {
                type: 'string',
                enum: ['before each', 'before all', 'after each', 'after all'],
            },
            title: {
                type: 'array',
                items: {
                    type: 'string',
                },
            },
            body: {
                type: 'string',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.testRunnerHookExample100,
};
exports.TestRunnerHook = schema_tools_1.versionSchemas(exports.TestRunnerHook100);
