"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var testRunnerCommitExample100 = {
    authorEmail: 'me@company.com',
    authorName: 'Joe Doe',
    branch: 'master',
    message: 'greatest feature ever',
    sha: '69cc7efa6b8fec8896debd4b3a2fae2a6120d431',
    remoteOrigin: null,
};
exports.testRunnerCommitExample100 = testRunnerCommitExample100;
var TestRunnerCommit100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.commit',
        type: 'object',
        description: 'Commit information sent by the test runner',
        properties: {
            authorEmail: {
                type: ['string', 'null'],
                description: 'Usually author email',
            },
            authorName: {
                type: ['string', 'null'],
                description: 'Author name, like Joe Smith',
            },
            branch: {
                type: ['string', 'null'],
                description: 'Git branch',
            },
            message: {
                type: ['string', 'null'],
                description: 'Commit message',
            },
            sha: {
                type: ['string', 'null'],
                description: 'Typically a commit SHA',
            },
            remoteOrigin: {
                type: ['string', 'null'],
                description: 'Remote Git origin url',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: testRunnerCommitExample100,
};
exports.TestRunnerCommit100 = TestRunnerCommit100;
var testRunnerCommitExample110 = Object.assign({}, testRunnerCommitExample100, {
    defaultBranch: 'develop',
});
exports.testRunnerCommitExample110 = testRunnerCommitExample110;
var TestRunnerCommit110 = schema_tools_1.extend(TestRunnerCommit100, {
    schema: {
        description: 'Commit with pull request information',
        properties: {
            defaultBranch: {
                type: ['string', 'null'],
                description: 'Default branch for the build / pull request / pipeline',
            },
        },
    },
    example: testRunnerCommitExample110,
});
exports.TestRunnerCommit110 = TestRunnerCommit110;
var TestRunnerCommit = schema_tools_1.versionSchemas(TestRunnerCommit100, TestRunnerCommit110);
exports.TestRunnerCommit = TestRunnerCommit;
