"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_omit_1 = __importDefault(require("lodash.omit"));
var lodash_clonedeep_1 = __importDefault(require("lodash.clonedeep"));
var schema_tools_1 = require("@cypress/schema-tools");
exports.testRunnerCiExample100 = {
    provider: 'CircelCI',
    buildNumber: '123',
    params: {
        accountName: 'foo',
    },
};
exports.TestRunnerCi100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'testRunner.ci',
        type: 'object',
        description: 'CI information sent by the test runner',
        properties: {
            provider: {
                type: ['string', 'null'],
                description: 'name of the CI provider, like "Circle"',
            },
            buildNumber: {
                type: ['string', 'null'],
                description: 'CI issues build number',
            },
            params: {
                type: ['object', 'null'],
                description: 'Any additional CI parameters',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.testRunnerCiExample100,
};
exports.testRunnerCiExample110 = {
    provider: 'circle',
    params: {
        accountName: 'foo',
    },
};
var cloneCi110 = lodash_clonedeep_1.default(exports.TestRunnerCi100);
cloneCi110.example = exports.testRunnerCiExample110;
cloneCi110.schema.properties = lodash_omit_1.default(cloneCi110.schema.properties, 'buildNumber');
exports.TestRunnerCi110 = schema_tools_1.extend(cloneCi110, {});
var TestRunnerCi = schema_tools_1.versionSchemas(exports.TestRunnerCi100, exports.TestRunnerCi110);
exports.TestRunnerCi = TestRunnerCi;
