"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.screenshotExample100 = {
    height: 1904,
    id: '36b8ec3f-6d28-4292-9a53-7faac3be7cbf',
    instanceId: 'fdc5586c-bca7-48d9-b264-a65ca44e2e2e',
    testId: '747d18ae-bad0-463e-9280-e63b78723cec',
    testTitle: [
        'Project List',
        'lists projects',
        'displays all projects',
        '<select />',
    ],
    name: 'custom_title_for_screenshot.pmg',
    url: 'http://localhost:8484/img/cypress-inverse.png',
    width: 3358,
    takenAt: '2016-05-13T02:37:15.748Z',
};
exports.Screenshot100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'screenshot',
        description: 'Screenshot image connected to the test and stored in Cypress database',
        type: 'object',
        properties: {
            height: {
                type: 'integer',
                minimum: 0,
                description: 'image height in pixels',
            },
            id: {
                type: 'string',
                format: 'uuid',
                description: 'UUID for this screenshot record',
            },
            instanceId: {
                type: 'string',
                format: 'uuid',
                description: 'Parent instance GUID',
            },
            testId: {
                type: ['string', 'null'],
                format: 'uuid',
                description: 'Parent test GUID',
            },
            testTitle: {
                type: 'array',
                items: {
                    type: 'string',
                },
                description: 'Parts of the full test name',
            },
            name: {
                type: ['string', 'null'],
                description: 'Custom screenshot filename',
            },
            url: {
                type: 'string',
                format: 'uri',
                description: 'Url to download the screenshot',
            },
            width: {
                type: 'integer',
                minimum: 0,
                description: 'image width in pixels',
            },
            takenAt: {
                type: 'string',
                format: 'date-time',
                description: 'Local test runner timestamp to keep the screenshots sorted',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.screenshotExample100,
};
exports.Screenshot = schema_tools_1.versionSchemas(exports.Screenshot100);
