"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var example100 = {
    clientId: 'some-internal-id',
    uploadUrl: 'https://builds.cypress.io/564/screenshots/1.png',
};
exports.ScreenshotUploadUrl100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'ScreenshotUploadUrl',
        type: 'object',
        properties: {
            clientId: {
                type: 'string',
                description: 'Client internal id',
            },
            uploadUrl: {
                type: 'string',
                format: 'uri',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: example100,
};
var example200 = {
    uploadUrl: 'https://builds.cypress.io/564/screenshots/1.png',
    screenshotId: 'abc123',
};
exports.ScreenshotUploadUrl200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'ScreenshotUploadUrl',
        type: 'object',
        properties: {
            screenshotId: {
                type: 'string',
                description: 'Internal screenshot id assigned by the test runner',
            },
            uploadUrl: {
                type: 'string',
                format: 'uri',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: example200,
};
exports.ScreenshotUploadUrl = schema_tools_1.versionSchemas(exports.ScreenshotUploadUrl100, exports.ScreenshotUploadUrl200);
