"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var screenshot_upload_url_1 = require("./screenshot-upload-url");
var example100 = {
    videoUploadUrl: 'http://builds.cypress.io/:build_id/screencast.mp4',
    screenshotUploadUrls: [
        {
            clientId: '23942340234-cgdfgdfg-4565656',
            uploadUrl: 'https://builds.cypress.io/111/screenshots/aaaa.png',
        },
    ],
};
exports.PutInstanceResponse100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PutInstanceResponse',
        type: 'object',
        properties: {
            videoUploadUrl: {
                type: 'string',
                format: 'uri',
            },
            screenshotUploadUrls: {
                type: 'array',
                see: screenshot_upload_url_1.ScreenshotUploadUrl100,
                items: __assign({}, screenshot_upload_url_1.ScreenshotUploadUrl100.schema),
            },
        },
        required: ['screenshotUploadUrls'],
        additionalProperties: false,
    },
    example: example100,
};
var example200 = {
    videoUploadUrl: 'http://builds.cypress.io/:build_id/screencast.mp4',
    screenshotUploadUrls: [
        {
            screenshotId: 'abc123',
            uploadUrl: 'https://builds.cypress.io/111/screenshots/aaaa.png',
        },
    ],
};
exports.PutInstanceResponse200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PutInstanceResponse',
        type: 'object',
        properties: {
            videoUploadUrl: {
                type: 'string',
                format: 'uri',
            },
            screenshotUploadUrls: {
                type: 'array',
                see: screenshot_upload_url_1.ScreenshotUploadUrl200,
                items: __assign({}, screenshot_upload_url_1.ScreenshotUploadUrl200.schema),
            },
        },
        required: ['screenshotUploadUrls'],
        additionalProperties: false,
    },
    example: example200,
};
exports.PutInstanceResponse = schema_tools_1.versionSchemas(exports.PutInstanceResponse100, exports.PutInstanceResponse200);
