"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var test_runner_cypress_stats_1 = require("./test-runner-cypress-stats");
var test_runner_hook_1 = require("./test-runner-hook");
var test_runner_mocha_reporter_stats_1 = require("./test-runner-mocha-reporter-stats");
var test_runner_screenshot_1 = require("./test-runner-screenshot");
var test_runner_test_1 = require("./test-runner-test");
var putInstanceRequestExample100 = {
    cypressConfig: {
        settingA: 'A',
        settingB: 'B',
        settingC: 'C',
        reporter: 'spec',
    },
    duration: 1234,
    tests: 1235,
    passes: 1232,
    failures: 1,
    pending: 2,
    video: true,
    error: null,
    failingTests: [
        {
            clientId: 'zdklfjsdf-234234sdf-sdf-3r23rvd',
            title: 'A Suite /// Test Title 2',
            stack: 'Test Stack 2',
            error: 'Test Error 2',
            duration: 3005,
            videoTimestamp: 98724,
        },
    ],
    screenshots: [test_runner_screenshot_1.testRunnerScreenshotExample100],
};
var PutInstanceRequest100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PutInstanceRequest',
        type: 'object',
        description: 'Sent with result of running an instance, very flexible to avoid breaking old test runners',
        properties: {
            cypressConfig: {
                type: ['object', 'null'],
            },
            cypressVersion: {
                type: ['string', 'null'],
            },
            ciProvider: {
                type: ['string', 'null'],
            },
            ciUrl: {
                type: ['string', 'null'],
            },
            stdout: {
                type: ['string', 'null'],
            },
            duration: {
                type: ['number', 'null'],
            },
            tests: {
                type: ['number', 'null'],
            },
            passes: {
                type: ['number', 'null'],
            },
            failures: {
                type: ['number', 'null'],
            },
            pending: {
                type: ['number', 'null'],
            },
            video: {
                type: ['boolean', 'null'],
            },
            spec: {
                type: ['string', 'null'],
            },
            error: {
                type: ['string', 'null'],
            },
            failingTests: {
                type: ['array', 'null'],
            },
            screenshots: {
                type: ['array', 'null'],
                items: __assign({}, test_runner_screenshot_1.TestRunnerScreenshot100.schema),
                see: test_runner_screenshot_1.TestRunnerScreenshot100,
            },
        },
        required: [],
        additionalProperties: true,
    },
    example: putInstanceRequestExample100,
};
var example200 = {
    cypressConfig: {},
    error: null,
    stats: test_runner_cypress_stats_1.testRunnerCypressStatsExample100,
    reporterStats: test_runner_mocha_reporter_stats_1.TestRunnerMochaReporterStats100.example,
    hooks: [test_runner_hook_1.TestRunnerHook100.example],
    tests: [test_runner_test_1.testRunnerTestExample100],
    video: true,
    screenshots: [test_runner_screenshot_1.testRunnerScreenshotExample200],
    stdout: 'something there',
};
exports.PutInstanceRequest200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PutInstanceRequest',
        type: 'object',
        properties: {
            cypressConfig: {
                type: 'object',
                description: 'Cypress test runner config',
            },
            error: {
                type: ['string', 'null'],
                description: 'Test runner error message',
            },
            stats: __assign({}, test_runner_cypress_stats_1.TestRunnerCypressStats100.schema, { see: test_runner_cypress_stats_1.TestRunnerCypressStats100, description: 'Similar to Mocha reporter stats but with "skipped" count' }),
            reporterStats: __assign({}, test_runner_mocha_reporter_stats_1.TestRunnerMochaReporterStats100.schema, { type: ['object', 'null'], see: test_runner_mocha_reporter_stats_1.TestRunnerMochaReporterStats100 }),
            hooks: {
                type: ['array', 'null'],
                items: __assign({}, test_runner_hook_1.TestRunnerHook100.schema),
                see: test_runner_hook_1.TestRunnerHook100,
            },
            tests: {
                type: ['array', 'null'],
                items: __assign({}, test_runner_test_1.TestRunnerTest100.schema),
                see: test_runner_test_1.TestRunnerTest100,
            },
            stdout: {
                type: ['string', 'null'],
                description: 'Standard output from the test runner',
            },
            video: {
                type: 'boolean',
                description: 'was video recorded or not',
            },
            screenshots: {
                type: ['array', 'null'],
                items: __assign({}, test_runner_screenshot_1.TestRunnerScreenshot200.schema),
                see: test_runner_screenshot_1.TestRunnerScreenshot200,
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: example200,
};
exports.PutInstanceRequest = schema_tools_1.versionSchemas(PutInstanceRequest100, exports.PutInstanceRequest200);
