"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var postRunResponseExample100 = {
    buildId: '00748421-e035-4a3d-8604-8468cc48bdb5',
};
var PostRunResponse100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunResponse',
        type: 'object',
        properties: {
            buildId: {
                type: 'string',
                format: 'uuid',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: postRunResponseExample100,
};
var postRunResponseExample200 = {
    runId: '00748421-e035-4a3d-8604-8468cc48bdb5',
    machineId: '5d82e54f-a4e9-48a0-b627-1502185dc2a4',
    groupId: 'a-plan-id',
    runUrl: 'https://dashboard.cypress.io/#/projects/cjvoj7/runs/12',
};
var PostRunResponse200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunResponse',
        type: 'object',
        description: 'Renamed `buildId` to `runId`, added `groupId` and `machineId`',
        properties: {
            runId: {
                type: 'string',
                format: 'uuid',
            },
            machineId: {
                type: 'string',
                format: 'uuid',
            },
            groupId: {
                type: 'string',
            },
            runUrl: {
                type: 'string',
                format: 'uri',
                description: 'Dashboard URL of this run',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: postRunResponseExample200,
};
exports.PostRunResponse = schema_tools_1.versionSchemas(PostRunResponse100, PostRunResponse200);
