"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_omit_1 = __importDefault(require("lodash.omit"));
var lodash_clonedeep_1 = __importDefault(require("lodash.clonedeep"));
var schema_tools_1 = require("@cypress/schema-tools");
var test_runner_ci_1 = require("./test-runner-ci");
var test_runner_commit_1 = require("./test-runner-commit");
var test_runner_platform_1 = require("./test-runner-platform");
var postRunRequestExample100 = {
    projectId: 'abc123',
    recordKey: 'f858a2bc-b469-4e48-be67-0876339ee7e1',
    commitAuthor: 'Jane Lane',
    commitAuthorName: 'Jane Lane',
    commitAuthorEmail: 'janelane@example.com',
    commitMessage: 'A lot of awesome code',
    commitSha: '83fb86a31f05490d9ed39922dcbdbdbc0747c8d0',
    commitBranch: 'master',
    remoteOrigin: 'https://github.com/username/repo.git',
    ciProvider: 'CircelCI',
    ciBuildNumber: '123',
    ciParams: {
        accountName: 'foo',
    },
    groupId: null,
    specs: ['spec.js'],
};
var PostRunRequest100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunRequest',
        type: 'object',
        properties: {
            projectId: {
                type: 'string',
                format: 'projectId',
            },
            recordKey: {
                type: 'string',
                format: 'uuid',
            },
            commitAuthor: {
                type: ['string', 'null'],
                deprecated: 'use "commitAuthorName"',
            },
            commitAuthorName: {
                type: ['string', 'null'],
            },
            commitAuthorEmail: {
                type: ['string', 'null'],
            },
            commitMessage: {
                type: ['string', 'null'],
            },
            commitSha: {
                type: ['string', 'null'],
            },
            commitBranch: {
                type: ['string', 'null'],
            },
            remoteOrigin: {
                type: ['string', 'null'],
            },
            ciProvider: {
                type: ['string', 'null'],
            },
            ciBuildNum: {
                type: ['string', 'null'],
                description: 'Old, use "ciBuildNumber" instead',
            },
            ciBuildNumber: {
                type: ['string', 'null'],
            },
            ciParams: {
                type: ['object', 'null'],
                description: 'Additional CI parameters',
            },
            groupId: {
                type: ['string', 'null'],
                description: 'Obsolete group id',
            },
            specPattern: {
                type: ['string', 'null'],
                description: 'Spec wildcard',
            },
            specs: {
                type: ['array', 'null'],
                description: 'spec filenames',
                items: {
                    type: 'string',
                },
            },
        },
        required: ['projectId', 'recordKey'],
        additionalProperties: true,
    },
    example: postRunRequestExample100,
};
var postRunRequestExample200 = {
    projectId: 'abc123',
    recordKey: 'f858a2bc-b469-4e48-be67-0876339ee7e1',
    commit: {
        authorName: 'Jane Lane',
        authorEmail: 'janelane@example.com',
        message: 'A lot of awesome code',
        sha: '83fb86a31f05490d9ed39922dcbdbdbc0747c8d0',
        branch: 'master',
        remoteOrigin: 'https://github.com/username/repo.git',
    },
    ci: {
        provider: 'CircelCI',
        buildNumber: '123',
        params: {
            accountName: 'foo',
        },
    },
    specs: ['foo-spec.js', 'bar-spec.js'],
    specPattern: '*-spec.js',
    platform: {
        osName: 'win32',
        osVersion: '32.10',
        browserName: 'Chrome',
        browserVersion: '64.0',
        osMemory: {
            free: 100,
            total: 200,
        },
        osCpus: [
            {
                model: 'Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz',
                speed: 2800,
                times: {
                    user: 300415800,
                    nice: 200800,
                    sys: 94852500,
                    idle: 649447000,
                    irq: 0,
                },
            },
        ],
    },
};
var PostRunRequest200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunRequest',
        type: 'object',
        description: 'Preparing for parallel builds',
        properties: {
            projectId: {
                type: 'string',
                format: 'projectId',
            },
            recordKey: {
                type: 'string',
                format: 'uuid',
            },
            commit: __assign({}, test_runner_commit_1.TestRunnerCommit100.schema, { type: ['object', 'null'], see: test_runner_commit_1.TestRunnerCommit100 }),
            ci: __assign({}, test_runner_ci_1.TestRunnerCi100.schema, { type: ['object', 'null'], see: test_runner_ci_1.TestRunnerCi100 }),
            specs: {
                type: 'array',
                minItems: 1,
                description: 'Spec filenames relative from the project root folder, example: "cypress/integration/foo-spec.js"',
                items: {
                    type: 'string',
                },
            },
            specPattern: {
                type: ['string', 'null'],
                description: 'User file pattern when running the specs',
            },
            platform: __assign({}, test_runner_platform_1.TestRunnerPlatform100.schema, { see: test_runner_platform_1.TestRunnerPlatform100 }),
        },
        required: true,
        additionalProperties: false,
    },
    example: postRunRequestExample200,
};
var postRunRequestExample210 = Object.assign({}, postRunRequestExample200, {
    commit: {
        authorName: 'Jane Lane',
        authorEmail: 'janelane@example.com',
        message: 'A lot of awesome code',
        sha: '83fb86a31f05490d9ed39922dcbdbdbc0747c8d0',
        branch: 'master',
        remoteOrigin: 'https://github.com/username/repo.git',
        defaultBranch: 'develop',
    },
    ci: lodash_omit_1.default(postRunRequestExample200.ci, 'buildNumber'),
    ciBuildId: 'build-or-workflow-num',
    parallel: true,
    group: 'frontend',
});
var clonePostRunRequest210 = lodash_clonedeep_1.default(PostRunRequest200);
clonePostRunRequest210.example = postRunRequestExample210;
var ci = clonePostRunRequest210.schema.properties.ci;
ci.properties = lodash_omit_1.default(ci.properties, 'buildNumber');
var PostRunRequest210 = schema_tools_1.extend(clonePostRunRequest210, {
    schema: {
        description: 'POST run request with CI build ID',
        properties: {
            ci: __assign({}, test_runner_ci_1.TestRunnerCi110.schema, { type: ['object', 'null'], see: test_runner_ci_1.TestRunnerCi110 }),
            commit: __assign({}, test_runner_commit_1.TestRunnerCommit110.schema, { type: ['object', 'null'], see: test_runner_commit_1.TestRunnerCommit110 }),
            ciBuildId: {
                type: ['string', 'null'],
                description: 'CI build id acquired from the client environment or explicitly provided by user',
            },
            parallel: {
                type: ['boolean', 'null'],
                description: 'Indicates if parallelized run is requested',
            },
            group: {
                type: ['string', 'null'],
                description: 'Run group name',
            },
        },
    },
});
exports.PostRunRequest = schema_tools_1.versionSchemas(PostRunRequest100, PostRunRequest200, PostRunRequest210);
