"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var postRunInstanceResponseExample100 = {
    instanceId: 'd91d2bcf-6398-46ed-b201-2fd90b188d5f',
};
var PostRunInstanceResponse100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunInstanceResponse',
        type: 'object',
        description: 'Returns information for created instance',
        properties: {
            instanceId: {
                type: 'string',
                format: 'uuid',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: postRunInstanceResponseExample100,
};
var postRunInstanceResponseExample200 = {
    instanceId: 'd91d2bcf-6398-46ed-b201-2fd90b188d5f',
};
var PostRunInstanceResponse200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunInstanceResponse',
        type: 'object',
        description: 'Returns information for claimed instance',
        properties: {
            instanceId: {
                type: 'string',
                format: 'uuid',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: postRunInstanceResponseExample200,
};
var PostRunInstanceResponse210 = {
    version: {
        major: 2,
        minor: 1,
        patch: 0,
    },
    schema: {
        title: 'PostRunInstanceResponse',
        type: 'object',
        description: 'Claimed instance with load balancing support',
        properties: {
            instanceId: {
                type: ['string', 'null'],
                format: 'uuid',
                description: 'Instance id if there is a spec to run',
            },
            spec: {
                type: ['string', 'null'],
                description: 'Spec filename to execute, if there is one to run',
            },
            totalInstances: {
                type: 'integer',
                minimum: 0,
                description: 'Total number of instances for this run',
            },
            claimedInstances: {
                type: 'integer',
                minimum: 0,
                description: 'Number of finished or running instances',
            },
            estimatedWallClockDuration: {
                type: ['integer', 'null'],
                description: 'Estimated wall clock duration in milliseconds',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: {
        instanceId: 'e9e81b5e-cc58-4026-b2ff-8ae3161435a6',
        spec: 'integration/a-spec.js',
        totalInstances: 18,
        claimedInstances: 7,
        estimatedWallClockDuration: 8382,
    },
};
exports.PostRunInstanceResponse = schema_tools_1.versionSchemas(PostRunInstanceResponse100, PostRunInstanceResponse200, PostRunInstanceResponse210);
