"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var test_runner_platform_1 = require("./test-runner-platform");
var postRunInstanceRequestExample100 = {
    browserName: 'Chromium',
    browserVersion: '41',
    osName: 'darwin',
    osVersion: '10.12.1',
    spec: 'integrations/forums_spec.js',
    osMemory: {
        free: 100,
        total: 200,
    },
    osCpus: [
        {
            model: 'Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz',
            speed: 2800,
            times: {
                user: 200415800,
                nice: 200800,
                sys: 94852500,
                idle: 649447000,
                irq: 0,
            },
        },
    ],
};
var PostRunInstanceRequest100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunInstanceRequest',
        type: 'object',
        description: 'Sent with instance results',
        properties: {
            browserName: {
                type: 'string',
            },
            browserVersion: {
                type: 'string',
            },
            osName: {
                type: 'string',
            },
            osVersion: {
                type: 'string',
            },
            osMemory: {
                type: ['object', 'null'],
            },
            osCpus: {
                type: ['array', 'null'],
            },
            spec: {
                type: ['string', 'null'],
                description: 'Name of the spec, or null if all specs were tested',
            },
        },
        required: ['browserName', 'browserVersion', 'osName', 'osVersion'],
        additionalProperties: false,
    },
    example: postRunInstanceRequestExample100,
};
var postRunInstanceRequestExample200 = {
    platform: {
        browserName: 'Chromium',
        browserVersion: '41',
        osName: 'darwin',
        osVersion: '10.12.1',
        osMemory: {
            free: 100,
            total: 200,
        },
        osCpus: [
            {
                model: 'Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz',
                speed: 2800,
                times: {
                    user: 200415800,
                    nice: 200800,
                    sys: 94852500,
                    idle: 649447000,
                    irq: 0,
                },
            },
        ],
    },
    spec: 'integration/forums_spec.js',
    machineId: 'd91d2bcf-6398-46ed-b201-2fd90b188d5f',
    groupId: 'darwin-Chromium-41',
};
var PostRunInstanceRequest200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'PostRunInstanceRequest',
        type: 'object',
        description: 'Sent to claim an existing instance when starting to run it',
        properties: {
            platform: __assign({}, test_runner_platform_1.TestRunnerPlatform100.schema, { see: test_runner_platform_1.TestRunnerPlatform100 }),
            spec: {
                type: 'string',
            },
            machineId: {
                type: 'string',
                format: 'uuid',
            },
            groupId: {
                type: 'string',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: postRunInstanceRequestExample200,
};
var PostRunInstanceRequest210 = schema_tools_1.addProperty({
    schema: PostRunInstanceRequest200,
    description: 'Asking for next available spec to run in load balancing mode',
}, {
    property: 'spec',
    propertyType: ['string', 'null'],
    propertyFormat: null,
    propertyDescription: 'Spec can be null if asking the API to return next spec to run',
    isRequired: true,
    exampleValue: null,
});
exports.PostRunInstanceRequest = schema_tools_1.versionSchemas(PostRunInstanceRequest100, PostRunInstanceRequest200, PostRunInstanceRequest210);
