"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.platformExample101 = {
    osName: 'linux',
    osVersion: '14.04',
    osVersionFormatted: 'Ubuntu Linux - 14.04',
    browserName: 'Electron',
    browserVersion: '53.0.2785.143',
    osMemory: {
        free: 10000,
        total: 20000,
    },
    osCpus: [
        {
            model: 'Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz',
            speed: 2800,
            times: {
                user: 300415800,
                nice: 200800,
                sys: 94852500,
                idle: 649447000,
                irq: 0,
            },
        },
    ],
};
exports.Platform101 = {
    version: {
        major: 1,
        minor: 0,
        patch: 1,
    },
    schema: {
        title: 'platform',
        type: 'object',
        description: 'Browser and OS information returned by the API',
        properties: {
            osName: {
                type: ['string', 'null'],
                enum: ['linux', 'darwin', 'win32'],
                description: 'Operating system name, for example "win32"',
            },
            osVersion: {
                type: ['string', 'null'],
                description: 'Operating system version',
            },
            osVersionFormatted: {
                type: ['string', 'null'],
                description: 'User-friendly operating system and version string',
            },
            browserName: {
                type: ['string', 'null'],
                description: 'Browser name, for example Chrome',
            },
            browserVersion: {
                type: ['string', 'null'],
                description: 'Browser version, for example 65.0.2785.143',
            },
            osMemory: {
                type: ['object', 'null'],
                properties: {
                    free: {
                        type: 'integer',
                        minimum: 0,
                        required: true,
                    },
                    total: {
                        type: 'integer',
                        minimum: 0,
                        required: true,
                    },
                },
            },
            osCpus: {
                type: ['array', 'null'],
                description: 'Information for every detected CPU core',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.platformExample101,
};
exports.Platform = schema_tools_1.versionSchemas(exports.Platform101);
