"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var formats_1 = require("../formats");
var platform_1 = require("./platform");
var screenshot_1 = require("./screenshot");
var video_1 = require("./video");
var instanceExample100 = {
    browserName: 'chrome',
    browserVersion: '43',
    duration: 1424424,
    error: null,
    failures: 0,
    id: 'od9809-0352-4ad9-85d3-feeb1e0505d5',
    osVersionFormatted: 'Windows 7',
    osName: 'win32',
    osVersion: '7',
    passes: 28,
    pending: 4,
    status: 'running',
    spec: null,
    osMemory: platform_1.platformExample101.osMemory,
    osCpus: platform_1.platformExample101.osCpus,
    stdout: 'foobar',
};
exports.instanceExample100 = instanceExample100;
var Instance100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'Instance',
        description: 'Basic information about an instance',
        type: 'object',
        properties: {
            browserName: {
                type: ['string', 'null'],
            },
            browserVersion: {
                type: ['string', 'null'],
            },
            duration: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Duration in milliseconds',
            },
            error: {
                type: ['string', 'null'],
                description: 'An error, if any',
            },
            failures: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of failed tests. Could be null if the instance is still running',
            },
            id: {
                type: 'string',
                format: formats_1.formats.uuid.name,
            },
            osVersionFormatted: {
                type: ['string', 'null'],
            },
            osName: {
                type: ['string', 'null'],
            },
            osVersion: {
                type: ['string', 'null'],
            },
            passes: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of successfully completed tests',
            },
            pending: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of pending (non-executing) tests',
            },
            status: {
                type: 'string',
                description: 'The status of this instance',
            },
            spec: {
                type: ['string', 'null'],
                description: 'Spec filename, if any',
            },
            osMemory: {
                type: ['object', 'null'],
                properties: {
                    free: {
                        type: 'integer',
                        minimum: 0,
                        required: true,
                    },
                    total: {
                        type: 'integer',
                        minimum: 0,
                        required: true,
                    },
                },
            },
            osCpus: {
                type: ['array', 'null'],
                description: 'Information for every detected CPU core',
            },
            stdout: {
                type: ['string', 'null'],
                description: 'Standard text output from the test runner',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: instanceExample100,
};
exports.Instance100 = Instance100;
var instanceExample200 = {
    platform: {
        browserName: 'Electron',
        browserVersion: '53.0.2785.143',
        osName: 'linux',
        osVersion: '16.04',
        osVersionFormatted: 'Linux - 16.04',
        osCpus: [
            {
                model: 'Intel(R) Xeon(R) CPU E5-2680 v2 @ 2.80GHz',
                speed: 2800,
                times: {
                    user: 300415800,
                    nice: 200800,
                    sys: 94852500,
                    idle: 649447000,
                    irq: 0,
                },
            },
        ],
        osMemory: {
            free: 1000,
            total: 100000,
        },
    },
    createdAt: '2016-05-13T02:35:12.748Z',
    claimedAt: '2016-05-13T02:40:10.000Z',
    error: null,
    failed: 4,
    passed: 28,
    pending: 1,
    skipped: 0,
    completedAt: '2016-05-13T02:45:10.000Z',
    id: '6fc12cf8-e3cf-49cc-98eb-f9be68dbb569',
    machineId: 'ed7f8f34-bb17-4730-853a-112de7fc26e4',
    spec: 'users_list_spec.js',
    wallClockDuration: 1424424,
    wallClockStartedAt: '2016-05-13T02:30:10.000Z',
    wallClockEndedAt: null,
    status: 'failed',
    stdout: 'some output',
    screenshots: [screenshot_1.screenshotExample100],
    videos: [video_1.video100Example],
    groupId: 'linux-Electron-53-737bbfc285',
};
exports.instanceExample200 = instanceExample200;
var Instance200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'Instance',
        description: 'Information about a single test instance',
        type: 'object',
        properties: {
            platform: __assign({}, platform_1.Platform101.schema, { description: 'information available once the test runner finishes its run', see: platform_1.Platform101 }),
            createdAt: {
                type: 'string',
                format: 'date-time',
            },
            claimedAt: {
                type: ['string', 'null'],
                format: 'date-time',
                description: 'When this instance was claimed by a test runner',
            },
            wallClockDuration: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total time, ms',
            },
            completedAt: {
                type: ['string', 'null'],
                format: 'date-time',
                description: 'When this test instance has been completed',
            },
            error: {
                type: ['string', 'null'],
                description: 'An error, if any',
            },
            passed: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of successfully completed tests, when known',
            },
            pending: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of pending (non-executing) tests',
            },
            failed: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of failed tests',
            },
            skipped: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Number of tests skipped for some reason',
            },
            id: {
                type: 'string',
                format: formats_1.formats.uuid.name,
            },
            machineId: {
                type: ['string', 'null'],
                format: formats_1.formats.uuid.name,
                description: 'Machine that claimed or executed this particular instance',
            },
            spec: {
                type: ['string', 'null'],
                description: 'Filename of the spec, null only in exceptional cases',
            },
            wallClockStartedAt: {
                type: ['string', 'null'],
                format: 'date-time',
                description: 'When the tests started reported by the test runner',
            },
            wallClockEndedAt: {
                type: ['string', 'null'],
                format: 'date-time',
                description: 'When the tests finished, as reported by the test runner',
            },
            status: {
                type: 'string',
                format: 'instanceStatus',
                description: 'The status of this instance',
            },
            stdout: {
                type: ['string', 'null'],
                description: 'Standard output from the instance',
            },
            videos: {
                type: ['array', 'null'],
                items: __assign({}, video_1.Video100.schema),
                see: video_1.Video100,
            },
            screenshots: {
                type: ['array', 'null'],
                items: __assign({}, screenshot_1.Screenshot100.schema),
                see: screenshot_1.Screenshot100,
            },
            groupId: {
                type: ['string', 'null'],
                description: 'Represents unique environment hash of spec names and OS + browser',
                required: true,
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: instanceExample200,
};
exports.Instance200 = Instance200;
var instanceExample210 = Object.assign({}, instanceExample200, {
    integrationFolder: '/Users/name/git/project/cypress/integration',
    estimatedWallClockDuration: 8382,
    parallelEnabled: true,
    groupName: 'frontend',
});
exports.instanceExample210 = instanceExample210;
var Instance210 = schema_tools_1.extend(Instance200, {
    description: 'Includes estimatedWallClockDuration',
    schema: {
        properties: {
            integrationFolder: {
                type: ['string', 'null'],
                description: 'Integration folder',
            },
            estimatedWallClockDuration: {
                type: ['integer', 'null'],
                description: 'Estimated wall clock duration in milliseconds',
            },
            parallelEnabled: {
                type: 'boolean',
                description: 'Indicates prallelized run was requested',
            },
            groupName: {
                type: ['string', 'null'],
                description: 'Associated run group name',
            },
        },
    },
    example: instanceExample210,
});
exports.Instance210 = Instance210;
var Instance = schema_tools_1.versionSchemas(Instance100, Instance200, Instance210);
exports.Instance = Instance;
