import { ObjectSchema } from '@cypress/schema-tools';
import { instanceStatus, ISODateString, milliseconds, osCpu, osMemory, osName, uuid } from '../objects';
import { PlatformExample101 } from './platform';
import { ScreenshotExample100 } from './screenshot';
import { VideoExample100 } from './video';
declare type InstanceExample100 = {
    browserName: string | null;
    browserVersion: string | null;
    duration: milliseconds | null;
    error: string | null;
    failures: number | null;
    id: uuid;
    osCpus: osCpu[] | null;
    osMemory: osMemory | null;
    osName: osName | null;
    osVersion: string | null;
    osVersionFormatted: string | null;
    passes: number | null;
    pending: number | null;
    spec: string | null;
    status: string;
    stdout: string | null;
};
declare const instanceExample100: InstanceExample100;
declare const Instance100: ObjectSchema;
declare type InstanceExample200 = {
    platform: PlatformExample101;
    passed: number | null;
    pending: number | null;
    failed: number | null;
    skipped: number | null;
    wallClockStartedAt: ISODateString | null;
    wallClockEndedAt: ISODateString | null;
    wallClockDuration: milliseconds | null;
    status: instanceStatus;
    stdout: string | null;
    error: string | null;
    createdAt: ISODateString;
    claimedAt: ISODateString | null;
    completedAt: ISODateString | null;
    spec: string | null;
    id: uuid;
    machineId: uuid | null;
    screenshots: ScreenshotExample100[] | null;
    videos: VideoExample100[] | null;
    groupId: string | null;
};
declare const instanceExample200: InstanceExample200;
declare const Instance200: ObjectSchema;
declare type InstanceExample210 = InstanceExample200 & {
    integrationFolder: string | null;
    estimatedWallClockDuration: number | null;
    parallelEnabled: boolean;
    groupName: string | null;
};
declare const instanceExample210: InstanceExample210;
declare const Instance210: ObjectSchema;
declare const Instance: import("@cypress/schema-tools/src/objects").VersionedSchema;
export { Instance, Instance100, Instance200, Instance210, instanceExample100, instanceExample200, instanceExample210, InstanceExample100, InstanceExample200, InstanceExample210, };
