"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var ci_1 = require("./ci");
var commit_1 = require("./commit");
var instance_1 = require("./instance");
var screenshot_1 = require("./screenshot");
var test_1 = require("./test");
var video_1 = require("./video");
var getRunResponseExample100 = {
    id: '569a7cdd-24c9-4843-b4d7-b40b11c927ae',
    projectId: 'vczwdh',
    projectName: 'foo',
    buildNumber: 31,
    cypressVersion: '0.18.0',
    commitAuthorName: 'Gleb Bahmutov',
    commitAuthorEmail: null,
    commitMessage: 'this is an example',
    commitBranch: 'master',
    commitSha: 'abc1234',
    commitUrl: null,
    totalPasses: 32,
    totalFailures: 0,
    totalPending: 5,
    totalDuration: 26,
    createdAt: '2018-05-08T15:32:17.263Z',
    updatedAt: '2018-05-08T15:32:17.382Z',
    status: 'passed',
    ciUrl: 'https://foo.com/foo/bar/baz',
    ciProvider: 'circle',
    ciBuildNumber: '123',
    runUrl: 'https://project-url/build/id',
    projectUrl: 'https://project-url',
    instances: [instance_1.instanceExample100],
    orgId: '3840ed27-15fe-42e2-bedc-be67d06c910f',
    orgName: 'Wile E Coyote',
    orgDefault: true,
    tests: [test_1.testExample100],
    screenshots: [screenshot_1.screenshotExample100],
    videos: [video_1.video100Example],
};
var GetRunResponse100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'GetRunResponse',
        description: 'Information about a single run',
        type: 'object',
        properties: {
            commitAuthorName: {
                type: ['string', 'null'],
            },
            commitAuthorEmail: {
                type: ['string', 'null'],
            },
            commitMessage: {
                type: ['string', 'null'],
            },
            commitBranch: {
                type: ['string', 'null'],
            },
            commitSha: {
                type: ['string', 'null'],
            },
            commitUrl: {
                type: ['string', 'null'],
            },
            totalDuration: {
                type: ['integer', 'null'],
                minimum: 0,
            },
            ciUrl: {
                type: ['string', 'null'],
            },
            ciProvider: {
                type: ['string', 'null'],
            },
            ciBuildNumber: {
                type: ['string', 'null'],
            },
            id: {
                type: 'string',
                format: 'uuid',
            },
            projectId: {
                type: 'string',
                format: 'projectId',
            },
            projectName: {
                type: 'string',
            },
            buildNumber: {
                type: 'integer',
                description: 'Cypress build number',
            },
            cypressVersion: {
                type: 'string',
                format: 'semver',
            },
            totalPasses: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of passed tests',
            },
            totalFailures: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of failed tests',
            },
            totalPending: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of pending tests',
            },
            createdAt: {
                type: 'string',
                format: 'date-time',
                description: 'when the run was inserted into database',
            },
            updatedAt: {
                type: 'string',
                format: 'date-time',
            },
            status: {
                type: 'string',
                format: 'runStatus',
            },
            runUrl: {
                type: 'string',
                format: 'uri',
                description: 'Dashboard URL of this run',
            },
            projectUrl: {
                type: ['string', 'null'],
                format: 'uri',
                description: 'Dashboard URL of the project',
            },
            instances: {
                type: 'array',
                description: 'Summary of individual instances',
                items: __assign({}, instance_1.Instance100.schema),
                see: instance_1.Instance100,
            },
            orgId: {
                type: 'string',
                format: 'uuid',
                description: 'Organization GUI',
            },
            orgName: {
                type: 'string',
                description: 'Organization name',
            },
            orgDefault: {
                type: 'boolean',
                description: 'Is this organization default for the current user',
            },
            tests: {
                type: ['array', 'null'],
                description: 'Failed tests',
                items: __assign({}, test_1.Test100.schema),
                see: test_1.Test100,
            },
            screenshots: {
                type: ['array', 'null'],
                description: 'Screenshots',
                items: __assign({}, screenshot_1.Screenshot100.schema),
                see: screenshot_1.Screenshot100,
            },
            videos: {
                type: ['array', 'null'],
                description: 'Videos',
                items: __assign({}, video_1.Video100.schema),
                see: video_1.Video100,
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: getRunResponseExample100,
};
var getRunResponseExample200 = {
    id: 'd5db9cf7-bfa4-490c-a6a1-2f85da0c52fb',
    projectId: 'cjvoj7',
    projectName: 'my-test-project',
    buildNumber: 12,
    cypressVersion: '3.0.0',
    createdAt: '2018-04-02T20:44:02.470Z',
    completedAt: '2018-04-02T20:45:02.470Z',
    updatedAt: '2018-04-02T20:45:02.551Z',
    status: 'passed',
    totalDuration: 1234,
    totalFailed: 2,
    totalPassed: 10,
    totalPending: 1,
    totalSkipped: 1,
    specIsolation: true,
    specPattern: 'foo-*-spec.js',
    supportsLoadBalancing: false,
    commit: {
        authorEmail: 'gleb@cypress.io',
        authorName: 'Gleb',
        message: 'this is a test',
        branch: 'develop',
        sha: '683b7b315216085de6445735304115495e36b4ca',
        url: 'https://github.com/username/repo/commit/abcd1234',
    },
    ci: {
        url: 'https://ci.com/foo/bar/baz',
        provider: 'Travis',
        buildNumber: '123',
    },
    runUrl: 'https://dashboard.cypress.io/#/projects/cjvoj7/runs/12',
    projectUrl: 'https://dashboard.cypress.io/#/projects/cjvoj7',
    instances: [instance_1.instanceExample200],
    failedTests: [test_1.testExample100],
    orgId: '3f079ec0-3471-4231-877e-964aafed345a',
    orgName: 'my test org',
    orgDefault: true,
};
var GetRunResponse200 = {
    version: {
        major: 2,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'GetRunResponse',
        description: 'Information about a single run',
        type: 'object',
        properties: {
            id: {
                type: 'string',
                format: 'uuid',
            },
            projectId: {
                type: 'string',
                format: 'projectId',
            },
            totalDuration: {
                type: ['integer', 'null'],
                description: 'Duration in milliseconds from when the run was created until it was finished.',
            },
            projectName: {
                type: 'string',
            },
            buildNumber: {
                type: 'integer',
                description: 'Cypress build number',
            },
            cypressVersion: {
                type: 'string',
                format: 'semver',
            },
            commit: __assign({}, commit_1.Commit100.schema, { type: ['object', 'null'], see: commit_1.Commit100 }),
            ci: __assign({}, ci_1.Ci100.schema, { type: ['object', 'null'], see: ci_1.Ci100 }),
            totalPassed: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of passed tests over all instances',
            },
            totalFailed: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of failed tests over all instances',
            },
            totalPending: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of pending tests over all instances',
            },
            totalSkipped: {
                type: ['integer', 'null'],
                minimum: 0,
                description: 'Total number of skipped tests over all instances',
            },
            createdAt: {
                type: 'string',
                format: 'date-time',
                description: 'When the run was inserted into database',
            },
            completedAt: {
                type: ['string', 'null'],
                format: 'date-time',
                description: 'Determined from instances',
            },
            updatedAt: {
                type: 'string',
                format: 'date-time',
            },
            status: {
                type: 'string',
                format: 'runStatus',
            },
            runUrl: {
                type: 'string',
                format: 'uri',
                description: 'Dashboard URL of this run',
            },
            projectUrl: {
                type: 'string',
                format: 'uri',
                description: 'Dashboard URL of the project',
            },
            specPattern: {
                type: ['string', 'null'],
                description: 'Optional spec pattern used by the user to find spec files',
            },
            specIsolation: {
                type: 'boolean',
                description: 'Each spec was executed in isolation',
            },
            supportsLoadBalancing: {
                type: 'boolean',
                description: 'Flag indicating client supports load balancing of specs',
            },
            instances: {
                type: 'array',
                items: __assign({}, instance_1.Instance200.schema),
                see: instance_1.Instance200,
            },
            failedTests: {
                type: ['array', 'null'],
                items: __assign({}, test_1.Test100.schema),
                see: test_1.Test100,
            },
            orgId: {
                type: 'string',
                format: 'uuid',
                description: 'Organization GUI',
            },
            orgName: {
                type: 'string',
                description: 'Organization name',
            },
            orgDefault: {
                type: 'boolean',
                description: 'Is this organization default for the current user',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: getRunResponseExample200,
};
var getRunResponseExample210 = Object.assign({}, getRunResponseExample200, {
    instances: [instance_1.instanceExample210],
    commit: commit_1.commitExample110,
    scheduledToCompleteAt: '2018-05-15T19:15:41.477Z',
});
var GetRunResponse210 = schema_tools_1.extend(GetRunResponse200, {
    schema: {
        description: 'Run response with integration folder and PR number and URL',
        properties: {
            instances: {
                type: 'array',
                description: 'Summary of individual instances',
                items: __assign({}, instance_1.Instance210.schema),
                see: instance_1.Instance210,
            },
            commit: __assign({}, commit_1.Commit110.schema, { type: ['object', 'null'], see: commit_1.Commit110 }),
            scheduledToCompleteAt: {
                type: ['string', 'null'],
                format: 'date-time',
                description: 'Scheduled run completion timestamp',
            },
        },
    },
    example: getRunResponseExample210,
});
var GetRunResponse = schema_tools_1.versionSchemas(GetRunResponse100, GetRunResponse200, GetRunResponse210);
exports.GetRunResponse = GetRunResponse;
