"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var lodash_clonedeep_1 = __importDefault(require("lodash.clonedeep"));
var instance_1 = require("./instance");
var test_1 = require("./test");
var test_runner_hook_1 = require("./test-runner-hook");
exports.getInstanceDetailsResponseExample100 = __assign({}, instance_1.instanceExample210, { tests: [test_1.testExample100], hooks: [test_runner_hook_1.testRunnerHookExample100] });
var Instance100Clone = lodash_clonedeep_1.default(instance_1.Instance210);
Instance100Clone.version = {
    major: 1,
    minor: 0,
    patch: 0,
};
var GetInstanceResponse100 = schema_tools_1.addProperty({
    schema: Instance100Clone,
    title: 'GetInstanceResponse',
    description: 'All information related to instance',
}, {
    property: 'tests',
    propertyType: ['array', 'null'],
    propertyFormat: null,
    exampleValue: [test_1.testExample100],
    isRequired: true,
    propertyDescription: 'all tests for this instance',
    see: test_1.Test100,
}, {
    property: 'hooks',
    propertyType: ['array', 'null'],
    propertyFormat: null,
    exampleValue: [test_runner_hook_1.testRunnerHookExample100],
    isRequired: true,
    propertyDescription: 'all hooks for this instance',
    see: test_runner_hook_1.TestRunnerHook100,
}, {
    property: 'groupId',
    propertyDescription: 'Represents unique environment hash of spec names and OS + browser',
    propertyType: ['string', 'null'],
    propertyFormat: null,
    isRequired: false,
    exampleValue: 'linux-Electron-53-737bbfc285',
});
if (GetInstanceResponse100.schema.properties &&
    GetInstanceResponse100.schema.properties.tests) {
    GetInstanceResponse100.schema.properties.tests.items = lodash_clonedeep_1.default(test_1.Test100.schema);
    GetInstanceResponse100.schema.properties.tests.see = test_1.Test100;
}
if (GetInstanceResponse100.schema.properties &&
    GetInstanceResponse100.schema.properties.hooks) {
    GetInstanceResponse100.schema.properties.hooks.items = lodash_clonedeep_1.default(test_runner_hook_1.TestRunnerHook100.schema);
    GetInstanceResponse100.schema.properties.hooks.see = test_runner_hook_1.TestRunnerHook100;
}
exports.GetInstanceResponse = schema_tools_1.versionSchemas(GetInstanceResponse100);
