"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var commitExample100 = {
    authorEmail: 'me@company.com',
    authorName: 'Joe Doe',
    branch: 'master',
    message: 'greatest feature ever',
    sha: '69cc7efa6b8fec8896debd4b3a2fae2a6120d431',
    url: 'https://github.com/username/repo/commit/69cc7ef',
};
exports.commitExample100 = commitExample100;
var Commit100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'commit',
        type: 'object',
        description: 'Commit information returned by the API',
        properties: {
            authorEmail: {
                type: ['string', 'null'],
                description: 'Usually author email',
            },
            authorName: {
                type: ['string', 'null'],
                description: 'Author name, like Joe Smith',
            },
            branch: {
                type: ['string', 'null'],
                description: 'Git branch',
            },
            message: {
                type: ['string', 'null'],
                description: 'Commit message',
            },
            sha: {
                type: ['string', 'null'],
                description: 'Typically a commit SHA',
            },
            url: {
                type: ['string', 'null'],
                description: 'Optional source commit url',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: commitExample100,
};
exports.Commit100 = Commit100;
var commitExample110 = Object.assign({}, commitExample100, {
    pullRequestId: '797',
    pullRequestUrl: 'https://foo.com/foo/bar/pull/797',
});
exports.commitExample110 = commitExample110;
var Commit110 = schema_tools_1.extend(Commit100, {
    schema: {
        description: 'Includes pullRequestId and pullRequestUrl',
        properties: {
            pullRequestId: {
                type: ['string', 'null'],
                description: 'Pull request id',
            },
            pullRequestUrl: {
                type: ['string', 'null'],
                format: 'uri',
                description: 'URL of the pull request',
            },
        },
    },
    example: commitExample110,
});
exports.Commit110 = Commit110;
var Commit = schema_tools_1.versionSchemas(Commit100, Commit110);
exports.Commit = Commit;
