"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
exports.ciExample100 = {
    url: null,
    provider: 'CircelCI',
    buildNumber: '123',
};
exports.Ci100 = {
    version: {
        major: 1,
        minor: 0,
        patch: 0,
    },
    schema: {
        title: 'ci',
        type: 'object',
        description: 'CI information returned by the API',
        properties: {
            provider: {
                type: ['string', 'null'],
                description: 'name of the CI provider, like "Circle"',
            },
            buildNumber: {
                type: ['string', 'null'],
                description: 'CI issues build number',
            },
            url: {
                type: ['string', 'null'],
                description: 'CI specific URL if available',
            },
        },
        required: true,
        additionalProperties: false,
    },
    example: exports.ciExample100,
};
exports.Ci = schema_tools_1.versionSchemas(exports.Ci100);
