"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var schema_tools_1 = require("@cypress/schema-tools");
var dateTime = {
    name: 'date-time',
    description: 'ISO date time string you get with (new Date()).toISOString()',
    detect: /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-[0-9]{2}[tT ]\d{2}:\d{2}:\d{2}(?:\.\d+|)([zZ]|[+-]\d{2}:\d{2})$/,
    defaultValue: '1999-01-01T05:00:00.000Z',
};
var uuid = {
    name: 'uuid',
    description: 'GUID used through the system',
    detect: /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/,
    defaultValue: 'ffffffff-ffff-ffff-ffff-ffffffffffff',
};
var projectId = {
    name: 'projectId',
    description: 'our custom project ids like "ma3dkn"',
    detect: /^([a-z0-9]{6}|[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})$/,
    defaultValue: 'abc123',
    example: '4b7344',
};
var hookId = {
    name: 'hookId',
    description: 'all hook ids start with "h" - "h1", "h2", ...',
    detect: /^h\d+$/,
    example: 'h1',
};
var testId = {
    name: 'testId',
    description: 'all test ids start with "r" - "r1", "r2", ...',
    detect: /^r\d+$/,
    example: 'r1',
};
exports.semver = {
    name: 'semver',
    description: 'version string with numerical parts "major.minor.patch", example "1.2.10"',
    detect: /^\d+\.\d+\.\d+$/,
    example: '1.2.10',
};
var testState = {
    name: 'testState',
    description: 'test state matching Mocha labels',
    detect: /^(passed|pending|skipped|failed)$/,
    example: 'failed',
};
var instanceStatus = {
    name: 'instanceStatus',
    description: 'Status of a single instance',
    detect: /^(unclaimed|running|errored|timedOut|failed|passed|noTests|cancelled)$/,
    example: 'failed',
};
var runStatus = {
    name: 'runStatus',
    description: 'Status of a single run',
    detect: /^(running|errored|failed|timedOut|noTests|passed|overLimit)$/,
    example: 'running',
};
var commitSha = {
    name: 'commitSha',
    description: 'Commit SHA (7 o 40 hex characters)',
    detect: /^([a-f0-9]{7}|[a-f0-9]{40})$/i,
    example: '260c9c7 or 683b7b315216085de6445735304115495e36b4ca',
};
var durationEstimate = {
    name: 'durationEstimate',
    description: 'DB valid decimal for instance duration estimate',
    detect: /^\d{0,9}(\.\d{1,3})?$/,
    example: '5280.361',
};
exports.formats = {
    commitSha: commitSha,
    dateTime: dateTime,
    durationEstimate: durationEstimate,
    hookId: hookId,
    instanceStatus: instanceStatus,
    projectId: projectId,
    runStatus: runStatus,
    semver: exports.semver,
    testId: testId,
    testState: testState,
    uuid: uuid,
};
exports.jsonSchemaFormats = schema_tools_1.detectors(exports.formats);
exports.formatDefaults = schema_tools_1.getDefaults(exports.formats);
