# @cypress/json-schemas [![CircleCI](https://circleci.com/gh/cypress-io/json-schemas.svg?style=svg&circle-token=71184ee4c09dbccab236b1997b12e5ed282156d3)](https://circleci.com/gh/cypress-io/json-schemas)

> Public Cypress JSON schemas

**note** this repository is private, but the NPM is public.

See our [schema-tools](https://github.com/cypress-io/schema-tools) repo for more documentation on how to utilize these JSON schemas.

# Install

```
npm install
```

# Test

Builds, runs tests, and also self documents schema changes.

Uses [ava-ts](https://github.com/andywer/ava-ts#readme) to run Ava test runner directly against TypeScript test files. Use `npm run test` to build and test everything in the `test` folder.

To run a single test file, use command:

```
npx ava-ts test/<file-name.ts>
```

To update snapshots and use verbose reporter (prints test names):

```
npx ava-ts test/<file-name.ts> --verbose -u
```

# Deploy

Deployment is handled by [semantic-release](https://github.com/semantic-release/semantic-release) automatically when run in CI. The release version is determined by the commit message. Your commit message should be of [one of these types](https://github.com/angular/angular.js/blob/master/DEVELOPERS.md#type).
